
data_HS = [
 3.451e-1    3.468e0     -3.234e-3   -2.223e1    8.277e-1    4.366e-2    -1.782e0    124.7;
 3.247e-1  1.292e-1    -2.939e-3   -1.804e1    1.710e0     4.992e-2    -1.937e0    109.6
 1.229e-4    1.605e0     -2.125e-2   -1.734e1    2.996e0     1.414e-1    -4.691e0    106.6
 5.823e-2   2.566e-3    -2.505e-2   -2.226e1    6.387e-1    5.577e-2    -1.958e0    133.6
 5.236e-1    2.383e-2    -1.803e-5   -1.779e1    4.578e0     7.171e-2    -9.590e-2   125.1
 2.015e-4    7.667e-2    -3.516e-4   -2.060e1    5.444e-2    6.581e-2    -4.080e0    135.6
 3.102e-1    1.104e-2    -1.678e-2   -1.697e1    1.264e0     4.421e-2    -2.321e0    107.1
 5.184e-3    6.295e-6    -3.928e-3   -1.756e1    2.673e0     7.768e-2    -3.506e0    133.8
 1.736e-3    1.821e-1    -8.304e-2   -2.005e1    2.655e0     1.340e-1    3.431e-1    56.72
 7.144e-1    6.849e0     -1.361e-1   -2.391e1    3.936e0     8.050e-2    4.891e-1    29.59
 6.095e-2    1.813e-1    -7.300e-2   -1.559e1    2.121e0     9.130e-2    -3.549e-1   31.82
 1.590e-3    1.710e-1    -6.239e-2   -1.772e1    3.964e0     1.463e-1    9.815e-1    55.33
 2.658e-4    9.019e-1    -2.557e-2   -1.688e1    8.769e-1    1.663e-1    1.446e0     54.94
 6.399e-4    8.124e-2    -5.957e-2   -1.746e1    6.417e0     1.451e-1    -8.517e-1   60.26
 2.393e-3    1.038e-1    -7.161e-2   -1.779e1    3.998e0     1.341e-1    -1.303e-2   57.82
 1.643e-3    7.805e-1    -6.130e-2   -1.912e1    2.208e0     1.249e-1    -6.553e-1   50.61
];

data_HSD = [
 1.823e0     4.982e0     -1.527e-1   -2.445e1    5.076e-1    1.058e-1    2.689e0     104.5
 8.730e-1    1.749e-2    -1.100e-1   -1.485e1    1.106e0     1.983e-1    -8.686e0    98.08
 6.538e0     1.655e0     -1.211e-1   -1.860e1    3.490e0     2.885e-1    -1.870e-1   103.4
 8.050e-1    7.194e-2    -1.259e-1   -1.810e1    5.739e0     1.262e-1    6.306e-1    85.78
 3.178e-1    8.301e-2    -1.215e-1   -1.867e1    4.932e-2    1.860e-2    -1.641e1    102.2
 1.056e0     1.715e0     -1.216e-1   -2.053e1    8.365e-2    1.616e-1    -1.131e1    86.83
 9.669e-1    1.858e-1    -1.201e-1   -1.822e1    5.802e-1    8.620e-2    -5.795e0    91.06
 1.291e-1    2.120e0     -1.267e-1   -2.338e1    1.153e0     6.902e-2    -6.061e0    102.5
 1.124e-1    7.657e-2    -1.115e-1   -1.866e1    2.686e0     5.108e-2    -4.098e0    71.58
 2.370e-1    7.797e-1    7.144e-2    -1.883e1    2.987e-1    6.519e-3    -5.183e0    106.6
 2.968e-2    1.179e0     6.920e-2    -1.747e1    8.744e-1    5.775e-2    -4.024e0    57.36
 2.800e-3    1.323e-1    8.622e-2    -1.949e1    4.394e-1    6.258e-2    -4.981e0    81.79
 7.461e-3    2.338e-1    -7.771e-2   -1.827e1    1.091e0     3.782e-2    -7.471e0    73.15
 3.100e-4    2.013e-1    -4.935e-2   -1.741e1    2.397e1     1.629e-1    -2.163e0    151.8
 1.678e-3    7.336e-1    -4.619e-2   -1.700e1    4.719e0     1.210e-4    -1.569e1    103.45
 3.757e-1    4.823e0     -7.894e-2   -1.731e1    1.032e1     4.330e-2    -5.698e0    76.34
];

cud;
h = figure;
x = -200:0.5:50;

% Saraga
t1=1; t2=1; t3=-0.116; t4=-17.9; t5=1; t6=0.09; t7=-1.84; t8=100;
semilogy(x, t1 ./ (t2.*(exp(x.*t3 + t4)) + (t5.*exp(t6.*x + t7))) + t8,'Color',cud_black);
hold on;

xlabel('Voltage(mV)');
ylabel('Time(ms)');
set(h, 'Units', 'centimeters');
set(gca, 'FontSize', 8);
set(h, 'Position', [0 0 9 8]);
set(h, 'PaperSize', [9 8]);

for i = 1:8
    p = data_HS(i,:);
    y = p(1)./(p(2).*exp(p(3).*x+p(4))+p(5).*exp(p(6).*x+p(7)))+p(8);
    semilogy(x,y,'Color',cud_orange);

    p = data_HS(i+8,:);
    y = p(1)./(p(2).*exp(p(3).*x+p(4))+p(5).*exp(p(6).*x+p(7)))+p(8);
    semilogy(x,y,'Color',cud_skyBlue);
end
legend({'Original','Refitted cell 1', 'Refitted cell 2'});
title('Somatic H models');
hold off;


h = figure;
x = -200:0.5:50;

% Saraga
t1=1; t2=1; t3=-0.116; t4=-17.9; t5=1; t6=0.09; t7=-1.84; t8=100;
semilogy(x, t1 ./ (t2.*(exp(x.*t3 + t4)) + (t5.*exp(t6.*x + t7))) + t8,'Color',cud_black);
hold on; 

xlabel('Voltage(mV)');
ylabel('Time(ms)');
set(h, 'Units', 'centimeters');
set(gca, 'FontSize', 8); 
set(h, 'Position', [0 0 9 8]);
set(h, 'PaperSize', [9 8]);

for i = 1:8
    p = data_HSD(i,:);
    y = p(1)./(p(2).*exp(p(3).*x+p(4))+p(5).*exp(p(6).*x+p(7)))+p(8);
    semilogy(x,y,'Color',cud_orange);

    p = data_HSD(i+8,:);
    y = p(1)./(p(2).*exp(p(3).*x+p(4))+p(5).*exp(p(6).*x+p(7)))+p(8);
    semilogy(x,y,'Color',cud_skyBlue);
end
legend({'Original','Refitted cell 1', 'Refitted cell 2'});
title('Somatodendritic H models');
hold off;

