%fileloc = '~/research/project/img/eLife2016/';
sigstar_plot_type = 'scatter';
font_size = 12;

pause('on');

f=figure;
hold on;
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultTextFontSize',font_size);
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
X = [ones(1,length(scen4_inhw_hD0)) ones(1,length(scen4_excw_hD0))+1 ones(1,length(scen4_blh_excw_hD0))+2];
Y = [scen4_inhw_hD0' scen4_excw_hD0' scen4_blh_excw_hD0'];
scatter(X,Y,[],[0 0 0]);
%{
Mea_hD0 = [mean(scen4_meanVm_hD0) mean(scen5_meanVm_hD0)];
Mea_hD1 = [ mean(scen4_meanVm_hD1) mean(scen5_meanVm_hD1)];
Std_hD0 = [std(scen4_meanVm_hD0) std(scen5_meanVm_hD0)];
Std_hD1 = [std(scen4_meanVm_hD1) std(scen5_meanVm_hD1)];
%}
spread_lo = min([scen4_excw_hD0; scen4_blh_excw_hD0; scen4_inhw_hD0]);
spread_hi = max([scen4_excw_hD0; scen4_blh_excw_hD0; scen4_inhw_hD0]);
spread=spread_hi-spread_lo;
ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)]);
%errorbar([1 2], Mea_hD0, Std_hD0);
%errorbar([3 4], Mea_hD1, Std_hD1);
%boxplot(Y,X);
for i=1:16
  line([1 2], [scen4_inhw_hD0(i), scen4_excw_hD0(i)],'Color','k','LineStyle','-');
  line([2 3], [scen4_excw_hD0(i), scen4_blh_excw_hD0(i)],'Color','k');
end
%daspect([1.5 1 1]);
ax=gca;
ax.PlotBoxAspectRatio = [1 2 1];
%set(gca,'LooseInset',get(gca,'TightInset'));
%f.PaperUnits='inches';
f.PaperPosition=[0 0 1 2];
xlim([0 4]);
set(gca,'XTick',[1:3]);
set(gca,'XTickLabels',{'Inh', 'Exc', 'Exc -H'});
set(gca,'XTickLabelRotation',-45);
ylabel('Peak conductance (\muS)');
title('H_{S}');
% Stats
%{
[stat_results1, pval1] = phd_exc_stats_paired(scen4_meanVm_hD0, scen5_meanVm_hD0);
[stat_results2, pval2] = phd_exc_stats_paired(scen4_meanVm_hD1, scen5_meanVm_hD1);
G = {[1 2], [3 4]};
P = [pval1, pval2];
sigstar('scatter', G, P, struct('want_ticks', 1));
%}
%{
if fileloc
    filename = 'Fig1_suppl1_syn_Scen4.eps';
    print(f,sprintf('%s/%s', fileloc, filename),'-depsc2');
end
%}

pause(1);

f=figure;
hold on;
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultTextFontSize',font_size);
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
X = [ones(1,length(scen4_inhw_hD1)) ones(1,length(scen4_excw_hD1))+1 ones(1,length(scen4_blh_excw_hD1))+2];
Y = [scen4_inhw_hD1' scen4_excw_hD1' scen4_blh_excw_hD1'];
scatter(X,Y,[],[0 0 0]);
%{
Mea_hD0 = [mean(scen4_meanVm_hD0) mean(scen5_meanVm_hD0)];
Mea_hD1 = [ mean(scen4_meanVm_hD1) mean(scen5_meanVm_hD1)];
Std_hD0 = [std(scen4_meanVm_hD0) std(scen5_meanVm_hD0)];
Std_hD1 = [std(scen4_meanVm_hD1) std(scen5_meanVm_hD1)];
%}
spread_lo = min([scen4_excw_hD1; scen4_blh_excw_hD1; scen4_inhw_hD1]);
spread_hi = max([scen4_excw_hD1; scen4_blh_excw_hD1; scen4_inhw_hD1]);
spread=spread_hi-spread_lo;
ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)]);
%errorbar([1 2], Mea_hD0, Std_hD0);
%errorbar([3 4], Mea_hD1, Std_hD1);
%boxplot(Y,X);
for i=1:16
  line([1 2], [scen4_inhw_hD1(i), scen4_excw_hD1(i)],'Color','k','LineStyle','-');
  line([2 3], [scen4_excw_hD1(i), scen4_blh_excw_hD1(i)],'Color','k');
end
%daspect([1.5 1 1]);
ax=gca;
ax.PlotBoxAspectRatio = [1 2 1];
%set(gca,'LooseInset',get(gca,'TightInset'));
%f.PaperUnits='inches';
f.PaperPosition=[0 0 1 2];
xlim([0 4]);
set(gca,'XTick',[1:3]);
set(gca,'XTickLabels',{'Inh', 'Exc', 'Exc -H'});
set(gca,'XTickLabelRotation',-45);
ylabel('Peak conductance (\muS)');
title('H_{SD}');
% Stats
%{
[stat_results1, pval1] = phd_exc_stats_paired(scen4_meanVm_hD0, scen5_meanVm_hD0);
[stat_results2, pval2] = phd_exc_stats_paired(scen4_meanVm_hD1, scen5_meanVm_hD1);
G = {[1 2], [3 4]};
P = [pval1, pval2];
sigstar('scatter', G, P, struct('want_ticks', 1));
%}
%{
if fileloc
    filename = 'Fig1_suppl1_syn_Scen4.eps';
    print(f,sprintf('%s/%s', fileloc, filename),'-depsc2');
end
%}

pause(1);

f=figure;
hold on;
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultTextFontSize',font_size);
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
X = [ones(1,length(scen5_inhw_hD0)) ones(1,length(scen5_excw_hD0))+1 ones(1,length(scen5_blh_excw_hD0))+2 ones(1,length(scen5_blh_blks_excw_hD0))+3 ones(1,length(scen5_blh_blka_excw_hD0))+4];
Y = [scen5_inhw_hD0' scen5_excw_hD0' scen5_blh_excw_hD0' scen5_blh_blks_excw_hD0' scen5_blh_blka_excw_hD0'];
scatter(X,Y,[],[0 0 0]);
%{
Mea_hD0 = [mean(scen4_meanVm_hD0) mean(scen5_meanVm_hD0)];
Mea_hD1 = [ mean(scen4_meanVm_hD1) mean(scen5_meanVm_hD1)];
Std_hD0 = [std(scen4_meanVm_hD0) std(scen5_meanVm_hD0)];
Std_hD1 = [std(scen4_meanVm_hD1) std(scen5_meanVm_hD1)];
%}
spread_lo = min([scen5_excw_hD0; scen5_blh_excw_hD0; scen5_inhw_hD0; scen5_blh_blks_excw_hD0; scen5_blh_blka_excw_hD0]);
spread_hi = max([scen5_excw_hD0; scen5_blh_excw_hD0; scen5_inhw_hD0; scen5_blh_blks_excw_hD0; scen5_blh_blka_excw_hD0]);
spread=spread_hi-spread_lo;
ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)]);
%errorbar([1 2], Mea_hD0, Std_hD0);
%errorbar([3 4], Mea_hD1, Std_hD1);
%boxplot(Y,X);
for i=1:16
  line([1 2], [scen5_inhw_hD0(i), scen5_excw_hD0(i)],'Color','k','LineStyle','-');
  line([2 3], [scen5_excw_hD0(i), scen5_blh_excw_hD0(i)],'Color','k');
  line([3 4], [scen5_blh_excw_hD0(i), scen5_blh_blks_excw_hD0(i)],'Color','k');
  line([4 5], [scen5_blh_blks_excw_hD0(i), scen5_blh_blka_excw_hD0(i)],'Color','k');
end
%daspect([1.5 1 1]);
ax=gca;
ax.PlotBoxAspectRatio = [1 2 1];
%set(gca,'LooseInset',get(gca,'TightInset'));
%f.PaperUnits='inches';
f.PaperPosition=[0 0 1 2];
xlim([0 6]);
set(gca,'XTick',[1:5]);
set(gca,'XTickLabels',{'Inh', 'Exc', 'Exc -H', 'Exc -H -Kdrs', 'Exc -H -KA'});
set(gca,'XTickLabelRotation',-45);
ylabel('Peak conductance (\muS)');
title('H_{S}');
% Stats
%{
[stat_results1, pval1] = phd_exc_stats_paired(scen4_meanVm_hD0, scen5_meanVm_hD0);
[stat_results2, pval2] = phd_exc_stats_paired(scen4_meanVm_hD1, scen5_meanVm_hD1);
G = {[1 2], [3 4]};
P = [pval1, pval2];
sigstar('scatter', G, P, struct('want_ticks', 1));
%}
%{
if fileloc
    filename = 'Fig1_suppl1_syn_Scen4.eps';
    print(f,sprintf('%s/%s', fileloc, filename),'-depsc2');
end
%}

pause(1);

f=figure;
hold on;
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultTextFontSize',font_size);
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
X = [ones(1,length(scen5_inhw_hD1)) ones(1,length(scen5_excw_hD1))+1 ones(1,length(scen5_blh_excw_hD1))+2 ones(1,length(scen5_blh_blks_excw_hD1))+3 ones(1,length(scen5_blh_blka_excw_hD1))+4];
Y = [scen5_inhw_hD1' scen5_excw_hD1' scen5_blh_excw_hD1' scen5_blh_blks_excw_hD1' scen5_blh_blka_excw_hD1'];
scatter(X,Y,[],[0 0 0]);
%{
Mea_hD0 = [mean(scen4_meanVm_hD0) mean(scen5_meanVm_hD0)];
Mea_hD1 = [ mean(scen4_meanVm_hD1) mean(scen5_meanVm_hD1)];
Std_hD0 = [std(scen4_meanVm_hD0) std(scen5_meanVm_hD0)];
Std_hD1 = [std(scen4_meanVm_hD1) std(scen5_meanVm_hD1)];
%}
spread_lo = min([scen5_excw_hD1; scen5_blh_excw_hD1; scen5_inhw_hD1; scen5_blh_blks_excw_hD1; scen5_blh_blka_excw_hD1]);
spread_hi = max([scen5_excw_hD1; scen5_blh_excw_hD1; scen5_inhw_hD1; scen5_blh_blks_excw_hD1; scen5_blh_blka_excw_hD1]);
spread=spread_hi-spread_lo;
ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)]);
%errorbar([1 2], Mea_hD0, Std_hD0);
%errorbar([3 4], Mea_hD1, Std_hD1);
%boxplot(Y,X);
for i=1:16
  line([1 2], [scen5_inhw_hD1(i), scen5_excw_hD1(i)],'Color','k','LineStyle','-');
  line([2 3], [scen5_excw_hD1(i), scen5_blh_excw_hD1(i)],'Color','k');
  line([3 4], [scen5_blh_excw_hD1(i), scen5_blh_blks_excw_hD1(i)],'Color','k');
  line([4 5], [scen5_blh_blks_excw_hD1(i), scen5_blh_blka_excw_hD1(i)],'Color','k');
end
%daspect([1.5 1 1]);
ax=gca;
ax.PlotBoxAspectRatio = [1 2 1];
%set(gca,'LooseInset',get(gca,'TightInset'));
%f.PaperUnits='inches';
f.PaperPosition=[0 0 1 2];
xlim([0 6]);
set(gca,'XTick',[1:5]);
set(gca,'XTickLabels',{'Inh', 'Exc', 'Exc -H', 'Exc -H -Kdrs', 'Exc -H -KA'});
set(gca,'XTickLabelRotation',-45);
ylabel('Peak conductance (\muS)');
title('H_{SD}');
% Stats
%{
[stat_results1, pval1] = phd_exc_stats_paired(scen4_meanVm_hD0, scen5_meanVm_hD0);
[stat_results2, pval2] = phd_exc_stats_paired(scen4_meanVm_hD1, scen5_meanVm_hD1);
G = {[1 2], [3 4]};
P = [pval1, pval2];
sigstar('scatter', G, P, struct('want_ticks', 1));
%}
%{
if fileloc
    filename = 'Fig1_suppl1_syn_Scen4.eps';
    print(f,sprintf('%s/%s', fileloc, filename),'-depsc2');
end
%}

pause('off');
