% Reduction in peak power between scenario 5 and scenario 5
%fileloc = '~/research/project/img/eLife2016/';
function plot_subth_blh(scen5_meas_hD0, scen5_blhp_meas_hD0, scen5_blh_meas_hD0, scen5_meas_hD1, scen5_blhp_meas_hD1, scen5_blh_meas_hD1, meas_str, fileloc, filename)
    sigstar_plot_type = 'scatter';
    font_size = 12;

    pause('on');

    f=figure;
    hold on;
    set(0,'DefaultTextFontName','Arial');
    set(0,'DefaultTextFontSize',font_size);
    set(0,'DefaultAxesFontName','Arial');
    set(0,'DefaultAxesFontSize',font_size);
    X = [ones(1,length(scen5_meas_hD0)) ones(1,length(scen5_blhp_meas_hD0))+1 ones(1,length(scen5_blh_meas_hD0))+2 ones(1,length(scen5_meas_hD1))+3 ones(1,length(scen5_blhp_meas_hD1))+4 ones(1,length(scen5_blh_meas_hD1))+5];
    Y = [scen5_meas_hD0' scen5_blhp_meas_hD0' scen5_blh_meas_hD0' scen5_meas_hD1' scen5_blhp_meas_hD1' scen5_blh_meas_hD1'];
    scatter(X,Y,[],[0 0 0]);
    Mea_hD0 = [mean(scen5_meas_hD0) mean(scen5_blhp_meas_hD0) mean(scen5_blh_meas_hD0)];
    Mea_hD1 = [mean(scen5_meas_hD1) mean(scen5_blhp_meas_hD1) mean(scen5_blh_meas_hD1)];
    Std_hD0 = [std(scen5_meas_hD0) std(scen5_blhp_meas_hD0) std(scen5_blh_meas_hD0)];
    Std_hD0 = [std(scen5_meas_hD1) std(scen5_blhp_meas_hD1) std(scen5_blh_meas_hD1)];
    spread_lo = min([scen5_meas_hD0; scen5_blhp_meas_hD0; scen5_blh_meas_hD0; scen5_meas_hD1; scen5_blhp_meas_hD1; scen5_blh_meas_hD1]);
    spread_hi = max([scen5_meas_hD0; scen5_blhp_meas_hD0; scen5_blh_meas_hD0; scen5_meas_hD1; scen5_blhp_meas_hD1; scen5_blh_meas_hD1]);
    spread=spread_hi-spread_lo;
    ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)]);
    %errorbar([1 2], Mea_hD0, Std_hD0);
    %errorbar([3 4], Mea_hD1, Std_hD1);
    %boxplot(Y,X);
    for i=1:16
      line([1 2], [scen5_meas_hD0(i), scen5_blhp_meas_hD0(i)],'Color','k');
      line([2 3], [scen5_blhp_meas_hD0(i), scen5_blh_meas_hD0(i)],'Color','k');
      line([4 5], [scen5_meas_hD1(i), scen5_blhp_meas_hD1(i)],'Color','k');
      line([5 6], [scen5_blhp_meas_hD1(i), scen5_blh_meas_hD1(i)],'Color','k');
    end
    %daspect([1.5 1 1]);
    ax=gca;
    ax.PlotBoxAspectRatio = [1 2 1];
    %set(gca,'LooseInset',get(gca,'TightInset'));
    %f.PaperUnits='inches';
    f.PaperPosition=[0 0 1 2];
    xlim([0 6]);
    set(gca,'XTick',[1:6]);
    set(gca,'XTickLabels',{'H_{S}', 'H_{S},-H,pre exc', 'H_{S},-H', 'H_{SD}', 'H_{SD},-H,pre exc', 'H_{SD},-H'});
    set(gca,'XTickLabelRotation',-45);
    ylabel(meas_str);
%    ylabel('Mean V_{m} (mV)');
    % Stats
    [stat_results1, pval1] = phd_exc_stats_paired(scen5_meas_hD0, scen5_blhp_meas_hD0);
    [stat_results2, pval2] = phd_exc_stats_paired(scen5_blhp_meas_hD0, scen5_blh_meas_hD0);
    [stat_results3, pval3] = phd_exc_stats_paired(scen5_meas_hD1, scen5_blhp_meas_hD1);
    [stat_results4, pval4] = phd_exc_stats_paired(scen5_blhp_meas_hD1, scen5_blh_meas_hD1);

    [stat_results5, pval5] = phd_exc_stats_paired(scen5_meas_hD0, scen5_blh_meas_hD0);
    [stat_results6, pval6] = phd_exc_stats_paired(scen5_meas_hD1, scen5_blh_meas_hD1);
    G = {[1 2], [2 3], [4 5], [5 6], [1 3], [4 6]};
    P = [pval1, pval2, pval3, pval4, pval5, pval6];
    sigstar('scatter', G, P, struct('want_ticks', 1));
    if fileloc
        print(f,sprintf('%s/%s', fileloc, filename),'-dsvg');
    end

end
