% Reduction in peak power between scenario 5 and scenario 5
%fileloc = '~/research/project/img/eLife2016/';
sigstar_plot_type = 'scatter';
font_size = 12;

pause('on');

f=figure;
hold on;
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultTextFontSize',font_size);
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
X = [ones(1,length(scen4_meanVm_hD0)) ones(1,length(scen5_meanVm_hD0))+1 ones(1,length(scen4_meanVm_hD1))+2 ones(1,length(scen5_meanVm_hD1))+3];
Y = [scen4_meanVm_hD0' scen5_meanVm_hD0' scen4_meanVm_hD1' scen5_meanVm_hD1'];
scatter(X,Y,[],[0 0 0]);
Mea_hD0 = [mean(scen4_meanVm_hD0) mean(scen5_meanVm_hD0)];
Mea_hD1 = [ mean(scen4_meanVm_hD1) mean(scen5_meanVm_hD1)];
Std_hD0 = [std(scen4_meanVm_hD0) std(scen5_meanVm_hD0)];
Std_hD1 = [std(scen4_meanVm_hD1) std(scen5_meanVm_hD1)];
spread_lo = min([scen4_meanVm_hD0; scen5_meanVm_hD0; scen4_meanVm_hD1; scen5_meanVm_hD1]);
spread_hi = max([scen4_meanVm_hD0; scen5_meanVm_hD0; scen4_meanVm_hD1; scen5_meanVm_hD1]);
spread=spread_hi-spread_lo;
ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)]);
%errorbar([1 2], Mea_hD0, Std_hD0);
%errorbar([3 4], Mea_hD1, Std_hD1);
%boxplot(Y,X);
for i=1:16
  line([1 2], [scen4_meanVm_hD0(i), scen5_meanVm_hD0(i)],'Color','k');
  line([3 4], [scen4_meanVm_hD1(i), scen5_meanVm_hD1(i)],'Color','k');
end
%daspect([1.5 1 1]);
ax=gca;
ax.PlotBoxAspectRatio = [1 2 1];
%set(gca,'LooseInset',get(gca,'TightInset'));
%f.PaperUnits='inches';
f.PaperPosition=[0 0 1 2];
xlim([0 4]);
set(gca,'XTick',[1:4]);
set(gca,'XTickLabels',{'H_{S}, S-I', 'H_{S}, SD-I', 'H_{SD}, S-I', 'H_{SD}, SD-I'});
set(gca,'XTickLabelRotation',-45);
ylabel('Mean V_{m} (mV)');
% Stats
[stat_results1, pval1] = phd_exc_stats_paired(scen4_meanVm_hD0, scen5_meanVm_hD0);
[stat_results2, pval2] = phd_exc_stats_paired(scen4_meanVm_hD1, scen5_meanVm_hD1);
G = {[1 2], [3 4]};
P = [pval1, pval2];
sigstar('scatter', G, P, struct('want_ticks', 1));
if fileloc
    filename = 'Fig1_meanVm.eps';
    print(f,sprintf('%s/%s', fileloc, filename),'-depsc2');
end

pause(1);

f=figure;
hold on;
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
X = [ones(1,length(scen4_stdVm_hD0)) ones(1,length(scen5_stdVm_hD0))+1 ones(1,length(scen4_stdVm_hD1))+2 ones(1,length(scen5_stdVm_hD1))+3];
Y = [scen4_stdVm_hD0' scen5_stdVm_hD0' scen4_stdVm_hD1' scen5_stdVm_hD1'];
scatter(X,Y,[],[0 0 0]);
spread_lo = min([scen4_stdVm_hD0; scen5_stdVm_hD0; scen4_stdVm_hD1; scen5_stdVm_hD1]);
spread_hi = max([scen4_stdVm_hD0; scen5_stdVm_hD0; scen4_stdVm_hD1; scen5_stdVm_hD1]);
spread=spread_hi-spread_lo;
ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)]);
%boxplot(Y,X);
for i=1:16
  line([1 2], [scen4_stdVm_hD0(i), scen5_stdVm_hD0(i)],'Color','k');
  line([3 4], [scen4_stdVm_hD1(i), scen5_stdVm_hD1(i)],'Color','k');
end
%daspect([1 1 1]);
ax=gca;
ax.PlotBoxAspectRatio = [1 2 1];
f.PaperUnits='inches';
f.PaperPosition=[0 0 1 2];
%set(gca,'FontSize',12);
xlim([0 4]);
set(gca,'XTick',[1:4]);
set(gca,'XTickLabels',{'H_{S}, S-I', 'H_{S}, SD-I', 'H_{SD}, S-I', 'H_{SD}, SD-I'});
set(gca,'XTickLabelRotation',-45);
ylabel('STD V_{m} (mV)');
% Stats
[stat_results1, pval1] = phd_exc_stats_paired(scen4_stdVm_hD0, scen5_stdVm_hD0);
[stat_results2, pval2] = phd_exc_stats_paired(scen4_stdVm_hD1, scen5_stdVm_hD1);
G = {[1 2], [3 4]};
P = [pval1, pval2];
sigstar('scatter', G, P, struct('want_ticks', 1));

pause(1);

f=figure;
hold on;
no_hD0 = scen4_spikerate_hD0 < 4; % non-outliers
scen4_spikerate_hD0_no = scen4_spikerate_hD0(no_hD0);
scen5_spikerate_hD0_no = scen5_spikerate_hD0(no_hD0);
set(0,'DefaultTextFontName','Arial');
set(0,'DefaultTextFontSize',font_size);
set(0,'DefaultAxesFontName','Arial');
set(0,'DefaultAxesFontSize',font_size);
X = [ones(1,length(scen4_spikerate_hD0_no)) ones(1,length(scen5_spikerate_hD0_no))+1 ones(1,length(scen4_spikerate_hD1))+2 ones(1,length(scen5_spikerate_hD1))+3];
Y = [scen4_spikerate_hD0_no' scen5_spikerate_hD0_no' scen4_spikerate_hD1' scen5_spikerate_hD1'];
scatter(X,Y,[],[0 0 0]);
spread_lo = min([scen4_spikerate_hD0_no; scen5_spikerate_hD0_no; scen4_spikerate_hD1; scen5_spikerate_hD1]);
spread_hi = max([scen4_spikerate_hD0_no; scen5_spikerate_hD0_no; scen4_spikerate_hD1; scen5_spikerate_hD1])
spread=spread_hi-spread_lo
spread*0.2
spread_hi+spread*0.2
ylim([(spread_lo - spread*0.1) (spread_hi + spread*0.2)])
%boxplot(Y,X);
for i=1:length(scen4_spikerate_hD0_no)
  line([1 2], [scen4_spikerate_hD0_no(i), scen5_spikerate_hD0_no(i)],'Color','k');
end
for i=1:length(scen4_spikerate_hD1)
  line([3 4], [scen4_spikerate_hD1(i), scen5_spikerate_hD1(i)],'Color','k');
end
%daspect([1 1 1]);
ax=gca;
ax.PlotBoxAspectRatio = [1 2 1];
f.PaperUnits='inches';
f.PaperPosition=[0 0 1 2];
%set(gca,'FontSize',12);
xlim([0 4]);
set(gca,'XTick',[1:4]);
set(gca,'XTickLabels',{'H_{S}, S-I', 'H_{S}, SD-I', 'H_{SD}, S-I', 'H_{SD}, SD-I'});
set(gca,'XTickLabelRotation',-45);
ylabel('Spike rate (Hz)');
% Stats
[stat_results1, pval1] = phd_exc_stats_paired(scen4_spikerate_hD0_no, scen5_spikerate_hD0_no);
[stat_results2, pval2] = phd_exc_stats_paired(scen4_spikerate_hD1, scen5_spikerate_hD1);
G = {[1 2], [3 4]};
P = [pval1, pval2];
sigstar('scatter', G, P, struct('want_ticks', 1));

pause('off');
