
function plot_tvec_lines(mod, file_exc, file_inhp, file_inht)
    tvec_exc = dlmread(file_exc);
    if nargin < 4
        tvec_inh = dlmread(file_inhp);
    else
        tvec_inhp = dlmread(file_inhp);
        tvec_inht = dlmread(file_inht);
    end

    cud;
    f = figure;
    font_size = 12;
    set(0,'DefaultTextFontName','Arial');
    set(0,'DefaultTextFontSize',font_size);
    set(0,'DefaultAxesFontName','Arial');
    set(0,'DefaultAxesFontSize',font_size);
    for i=1:size(tvec_exc,1)
        t = tvec_exc(i,1);
        idx = tvec_exc(i,2);
        if idx > 6 || idx < 2
%        if idx ~= 3
            continue;
        end

%        line([t t], [idx idx+0.75], 'Color', cud_skyBlue);
        line([t t], [idx idx+0.75], 'Color', cud_black);
%        line([t-0.2 t+0.2], [idx+(0.75)/2 idx+(0.75)/2], 'Color', cud_black);	% horizontal crosses, but almost impossible to see zoomed out
    end

    if mod==1

    for i=1:size(tvec_inhp,1)
        t = tvec_inhp(i,1);
        idx = tvec_inhp(i,2);
        if idx > 6 || idx < 2
%        if idx ~= 3
            continue;
        end

%        line([t t], [idx idx+0.75], 'Color', cud_vermillion);
        line([t t], [idx idx+0.75], 'Color', cud_vermillion);
    end
    for i=1:size(tvec_inht,1)
        t = tvec_inht(i,1);
        idx = tvec_inht(i,2);
        if idx > 6 || idx < 2
%        if idx ~= 3
            continue;
        end

%        line([t t], [idx idx+0.75], 'Color', cud_orange);
        line([t t], [idx idx+0.75], 'Color', cud_skyBlue);
    end

    else

    % nomod 
    for i=1:size(tvec_inh,1)
        t = tvec_inh(i,1);
        idx = tvec_inh(i,2);
        if idx > 6 || idx < 2
%        if idx ~= 3
            continue;
        end

        line([t t], [idx idx+0.75], 'Color', cud_vermillion);
    end

    end

    set(gca,'LooseInset',get(gca,'TightInset'));
    set(gca,'YTick',[]);
    set(gca,'YTickLabel',[]);
    axis([0 200 2 6]); % xmin xmax ymin ymax
%    axis([0 250 3 3]); % xmin xmax ymin ymax
%    ylabel('Synaptic site');
    xlabel('Time (ms)');
    ax=gca;
    ax.PlotBoxAspectRatio = [6 1 1];
    f.PaperUnits = 'inches';
    f.PaperPosition = [0 0 6 1]; 
end
