
function plot_two_traces(A, B, xlim_range, mf, fileloc, props)
    if nargin < 6
        props = struct();
    end
    f=figure;
    f.PaperUnits = 'inches';
    f.PaperPosition = [0 0 4 4];
    set(gca,'LooseInset',get(gca,'TightInset'));
    font_size = 12;
    set(0,'DefaultTextFontName','Arial');
    set(0,'DefaultTextFontSize',font_size);
    set(0,'DefaultAxesFontName','Arial');
    set(0,'DefaultAxesFontSize',font_size);
    cud;
    if isfield(props,'colorized')
        cud1 = cud_black;
        cud2 = cud_skyBlue;
    else
        cud1 = cud_black;
        cud2 = cud1;
    end

    subplot(2,1,1);
    plot(A(:,1),A(:,2),'Color',cud1,'LineWidth',0.5);
    ax=gca;
    p_bottom = ax.Position(2);
%{
    ax.Position
    p_left = ax.Position(1);
%}
    ylim([-100 0]);
    xlim(xlim_range);

    xloc = min(xlim_range);
    if mf>0
        mf_iei = 1000/mf;
        num_cycles = range(xlim_range)/mf_iei;
        for x=0:num_cycles line([xloc xloc+(mf_iei/2)], [-90 -90], 'Color', cud_orange, 'LineWidth', 5); xloc=xloc+mf_iei; end
    end

    set(gca,'XTick',[min(xlim_range):2000:max(xlim_range)]);
    xlim_seconds = xlim_range * 1e-3;
%    set(gca,'XTickLabel',[min(xlim_seconds):2:max(xlim_seconds)]);
    set(gca,'XTickLabel',[]);
    set(gca,'YTick',[-90 -70 -50 -30]);
    ylabel('V_m (mV)');
    set(gca,'LooseInset',get(gca,'TightInset'));
    set(gca,'box','off');

    subplot(2,1,2);
    plot(B(:,1),B(:,2),'Color',cud2,'LineWidth',0.5);
    ax=gca;
    p = ax.Position;
    ax.Position = [p(1) p_bottom-p(4)-0.01 p(3) p(4)];
%{
    ax.Position
%}
    ylim([-100 0]);
    xlim(xlim_range);

    xloc = min(xlim_range);
    if mf>0
        mf_iei = 1000/mf;
        num_cycles = range(xlim_range)/mf_iei;
        for x=0:num_cycles line([xloc xloc+(mf_iei/2)], [-90 -90], 'Color', cud_orange, 'LineWidth', 5); xloc=xloc+mf_iei; end
    end

    set(gca,'XTick',[min(xlim_range):2000:max(xlim_range)]);
    xlim_seconds = xlim_range * 1e-3;
    set(gca,'XTickLabel',[min(xlim_seconds):2:max(xlim_seconds)]);
    xlabel('Time (s)','FontSize',14);
    set(gca,'YTick',[-90 -70 -50 -30]);
    ylabel('V_m (mV');
    set(gca,'LooseInset',get(gca,'TightInset'));
    set(gca,'box','off');

    if fileloc
        if ~isfield(props,'filename')
            disp(sprintf('ERROR: must provide filename'));
            return;
        end
        input('Press Enter to print.');
        filename = props.filename;
        disp(sprintf('PRINTING to file %s', filename));
        print(f, sprintf('%s/%s', fileloc, filename), '-dsvg');
    end

end
