
function [VS_all, VSblh_all] = plot_vector_strengths(m, mblh, desired_mo, freq)

    phd_exc_load_mod;
    mo_idx = find(mo==desired_mo);
    mf_idx = find(mf==freq);

    VS_all = [];
    N=length(m);
    Nblh=length(mblh);

    for i=1:N
        VS_all = [VS_all m(i).mod.mo(mo_idx).mf(mf_idx).psd.rel.psth.VS];
    end

    VSblh_all = [];
    for i=1:Nblh
        VSblh_all = [VSblh_all mblh(i).mod.mo(mo_idx).mf(mf_idx).psd.rel.psth.VS];
    end

    G=ones(1,N)
    Gblh=ones(1,Nblh)+1;

    boxplot([VS_all VSblh_all],[G Gblh]);

    set(gca,'XTickLabel',{'ctl','blh'})
    ylabel('Vector strength');
    title(sprintf('Vector strength, mo %g, mf %g', desired_mo, freq));
    set(gca,'FontSize',14)
end
