function [t_new, V_new] = removeSpikes(t, V, timeidx, thres, debug)

if nargin < 5
    debug = 0;
end

look_behind = 10; % how far back to cut a spike
mean_width = 50; % width is arbitrary but works
%disp(sprintf('*** setting width to %g\n', mean_width));

t_new = t;
V_new = V;

for i=1:length(timeidx)

    % Just remove a bit prior to the spike and after. We don't do fancy init_vm calculations here.
    cut_region = find(t > t(timeidx(i)) - look_behind & t < t(timeidx(i)) + mean_width);

    if debug
        V_new(cut_region) = 1;
    else
        V_new(cut_region) = NaN;
    end
    t_new(cut_region) = NaN;
end

% Now cut out NaN parts.
if debug
    figure; hold on;
    plot(t, V);
    plot(t, V_new, 'r');
end

V_new(isnan(V_new)) = []; 
t_new(isnan(t_new)) = [];

end
