%{
    Plot all PSTH times in polar form for two model distributions.
    Models should be constrained by the desired ranks.

    props:
        title_str
%}
function rose_plots(models1, models2, freq, leg_names, props)
    if nargin < 5
        props = struct();
    end
    if isfield(props,'FontSize')
        fontsize=props.FontSize;
    else
        fontsize=16;
    end
    if isfield(props,'want_ctl_bg')
        want_ctl_bg=props.want_ctl_bg;
        if want_ctl_bg
            models3=props.third;
        end
    else
        want_ctl_bg = 0;
    end

    cud;
    cud1 = cud_skyBlue;
    cud2 = cud_orange;
    cud3 = cud_grey;

    phd_exc_load_mod;
    mf_idx = find(mf==freq);

    grand_psth1 = [];
    grand_psth2 = [];
    for i=1:length(models1)
        psd = models1(i).mod.mo(2).mf(mf_idx).psd;
        if isempty(psd)
            continue;
        end

        diffs = models1(i).mod.mo(2).mf(mf_idx).psd.rel.psth.diffs;
        grand_psth1 = [grand_psth1 diffs];
    end
    for i=1:length(models2)
        psd = models2(i).mod.mo(2).mf(mf_idx).psd;
        if isempty(psd)
            continue;
        end

        diffs = models2(i).mod.mo(2).mf(mf_idx).psd.rel.psth.diffs;
        grand_psth2 = [grand_psth2 diffs];
    end

    period=1000/freq;
    grand_th1 = 2*pi*(mod(grand_psth1,period)/period);
    amean_th1 = angmean(grand_psth1, period)
    grand_th2 = 2*pi*(mod(grand_psth2,period)/period);
    amean_th2 = angmean(grand_psth2, period)
    [T1, R1] = rose(grand_th1,40);
    [T2, R2] = rose(grand_th2,40);

    if want_ctl_bg
        disp('YEP THIRD');
        grand_psth3 = [];
        for i=1:length(models3)
            psd = models3(i).mod.mo(2).mf(mf_idx).psd;
            if isempty(psd)
                continue;
            end

            diffs = models3(i).mod.mo(2).mf(mf_idx).psd.rel.psth.diffs;
            grand_psth3 = [grand_psth3 diffs];
        end
        grand_th3 = 2*pi*(mod(grand_psth3,period)/period);
        amean_th3 = angmean(grand_psth3, period)
        [T3, R3] = rose(grand_th3,40);
    end

    f=figure;
    set(gca,'FontSize',fontsize);
    h=polar(T1, R1./max(R1));
    h.Color = cud1;
    hold on;
    h=polar(T2, R2./max(R2));
    h.Color = cud2; 
    if want_ctl_bg
        h=polar(T3, R3./max(R3));
        h.Color = cud_grey;
        h.LineWidth=1.5;
    end
%compass(cos(amean_th1),sin(amean_th1));
%compass(cos(amean_th2),sin(amean_th2));

    % UGLY but needs to be done in R2015b; for R2016a and above, use polarplot()
    % cf., https://www.mathworks.com/matlabcentral/answers/91904-how-do-i-set-the-font-size-of-the-text-labels-in-a-polar-plot-in-matlab
    texth = findall(gcf,'Type','text');
    for i = 1:length(texth),
        set(texth(i),'FontSize',fontsize)
    end

    if isfield(props,'title_str')
        title(props.title_str,'FontSize',fontsize*1.5)
    end
    if isfield(props,'legend_orientation')
        legend_orientation=props.legend_orientation;
    else
        legend_orientation='horizontal';
    end
    if isfield(props,'want_legend')
        want_legend=props.want_legend;
    else
        want_legend=1;
    end
    if want_legend
        legend(leg_names,'Location','best','Orientation',legend_orientation,'FontSize',fontsize);
    end

%{
    xlabel('Post-stimulus time (ms)');
    ylabel('V_m (mV)');
%}

    if isfield(props,'filename')
        input('Press Enter to print.');
        filename = props.filename;
        disp(sprintf('PRINTING to file %s', filename));
    %    print(f, filename, '-dpng');
        print(f, filename, '-dsvg');
    end

end
