%{
    rotnumber - "Rotation Number"

    x - spike times
    y - times for release from inhibition during modulation

    Returns:
    Rnum - rotation number
%}

function [Rnum] = rotnumber(x, y, verbose)

    if nargin < 3
        verbose = 0;
    end
    aps_per_cycle = [];

    % First period to check is from 0 to y(1)
    %{
    if find(x < y(1))
        count = count + 1;
        if verbose
            disp(sprintf('PRE'));
        end
    end
    %}

    % Go through all inter-reference events (bins to check for spiking)
    N=length(y)-1;
    for i=1:N
        if verbose
            disp(sprintf('y(%d) %g <-> y(%d) %g', i, y(i), i+1, y(i+1)));
        end
        spikes = length(find(x < y(i+1) & x > y(i)));
        if verbose
            disp(sprintf('* %g spikes at y %d', spikes, y(i)));
        end
        aps_per_cycle = [aps_per_cycle spikes];
    end

    % Final period to check is from y(length) onwards (to end)
    %{
    if find(x < y(1)) 
        count = count + 1;
        if verbose
            disp(sprintf('POST'));
        end
    end
    %}

    % Return average number of spikes per cycle.
    Rnum = mean(aps_per_cycle);
end
