%{
    rrate

    x - spike times
    y - times for release from inhibition during modulation

    Returns:
    rr - response rate
    er - "extra" spikes rate ("error rate"?)
%}

function [rr, er, extras] = rrate(x, y, verbose)

    if nargin < 3
        verbose = 0;
    end
    count = 0;
    extras = 0;

    % First period to check is from 0 to y(1)
    %{
    if find(x < y(1))
        count = count + 1;
        if verbose
            disp(sprintf('PRE'));
        end
    end
    %}

    % Go through all inter-reference events (bins to check for spiking)
    for i=1:length(y)-1
        if verbose
            disp(sprintf('y(%d) %g <-> y(%d) %g', i, y(i), i+1, y(i+1)));
        end
        spikes = length(find(x < y(i+1) & x > y(i)));
        if spikes
            count = count + 1;
            if verbose
                disp(sprintf('*'));
            end
            if spikes > 1
                extras = spikes - 1; % each beyond the first is an "extra"
                if verbose
                    disp(sprintf('  %d extras', spikes-1));
                end
            end
        end
        spikes = 0;
    end

    % Final period to check is from y(length) onwards (to end)
    %{
    if find(x < y(1)) 
        count = count + 1;
        if verbose
            disp(sprintf('POST'));
        end
    end
    %}

    % Return no. of times there were *any* spikes in each period, divided by 
    % total number of periods of modulatory input - i.e., response rate
    rr = count / (length(y)-1);
    % Extra/error rate is number of extras fed through a sigmoid function to normalize
    % between 0 and 1, with 0 being no extra spikes and getting close to 1 with more
    % extra spikes.
    er = 2./(1+exp(-0.2.*extras))-1;
end
