
function [VS, R] = vector_strength(data, period)

    N = length(data);
    theta_vals = 2*pi*(mod(data,period)/period);
    x = sum(cos(theta_vals));
    y = sum(sin(theta_vals));

    VS = (1/N) * sqrt(x^2 + y^2);

    R = 2*N*VS;

end
