(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     16642,        382]
NotebookOptionsPosition[     16210,        363]
NotebookOutlinePosition[     16548,        378]
CellTagsIndexPosition[     16505,        375]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.6766281607829065`*^9, 3.6766281615429077`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"model", "=", "\"\<kinHetExtended\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"step", "=", "\"\<delayStep\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"model", "\[Equal]", "\"\<kinHet\>\""}], "||", 
      RowBox[{"model", "\[Equal]", "\"\<kinHetExtended\>\""}], "||", 
      RowBox[{"model", "\[Equal]", "\"\<kinHetExtended2\>\""}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"bMin", "=", "2"}], ";", "\[IndentingNewLine]", 
      RowBox[{"bMax", "=", "2"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"kMin", "=", "13"}], ";", "\[IndentingNewLine]", 
      RowBox[{"kMax", "=", "17"}], ";"}], "\[IndentingNewLine]", ","}], "]"}],
    ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"model", "\[Equal]", "\"\<tempHet\>\""}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"bMin", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"bMax", "=", "3"}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"kMin", "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"kMax", "=", "5"}], ";"}], "\[IndentingNewLine]", ","}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"!", 
    RowBox[{"DirectoryQ", "[", "\"\<CFunctions/\>\"", "]"}]}], ",", 
   RowBox[{"CreateDirectory", "[", "\"\<CFunctions\>\"", "]"}], ","}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"!", 
    RowBox[{"DirectoryQ", "[", 
     RowBox[{"\"\<CFunctions/\>\"", "<>", 
      RowBox[{"ToString", "[", "step", "]"}]}], "]"}]}], ",", 
   RowBox[{"CreateDirectory", "[", 
    RowBox[{"\"\<CFunctions/\>\"", "<>", 
     RowBox[{"ToString", "[", "step", "]"}]}], "]"}], ","}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"fns", "=", 
     RowBox[{"Flatten", "@", 
      RowBox[{"Import", "[", 
       RowBox[{
        RowBox[{
        "\"\<Functions/\>\"", "<>", "step", "<>", "\"\</B\>\"", "<>", 
         RowBox[{"ToString", "[", "bb", "]"}], "<>", "\"\<K\>\"", "<>", 
         RowBox[{"ToString", "[", "kk", "]"}], "<>", "model", "<>", "step", 
         "<>", "\"\<fns.csv\>\""}], ",", "\"\<csv\>\""}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqnsUp", "=", 
     RowBox[{"Flatten", "@", 
      RowBox[{"Import", "[", 
       RowBox[{
        RowBox[{
        "\"\<Functions/\>\"", "<>", "step", "<>", "\"\</B\>\"", "<>", 
         RowBox[{"ToString", "[", "bb", "]"}], "<>", "\"\<K\>\"", "<>", 
         RowBox[{"ToString", "[", "kk", "]"}], "<>", "model", "<>", "step", 
         "<>", "\"\<eqnsUp.csv\>\""}], ",", "\"\<csv\>\""}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"eqnsDown", "=", 
     RowBox[{"Flatten", "@", 
      RowBox[{"Import", "[", 
       RowBox[{
        RowBox[{
        "\"\<Functions/\>\"", "<>", "step", "<>", "\"\</B\>\"", "<>", 
         RowBox[{"ToString", "[", "bb", "]"}], "<>", "\"\<K\>\"", "<>", 
         RowBox[{"ToString", "[", "kk", "]"}], "<>", "model", "<>", "step", 
         "<>", "\"\<eqnsDown.csv\>\""}], ",", "\"\<csv\>\""}], "]"}]}]}], ";",
     "\[IndentingNewLine]", 
    RowBox[{"subs", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"fns", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "\[Rule]", 
        RowBox[{"\"\<x[\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"i", "-", "1"}], "]"}], "<>", "\"\<]\>\""}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "fns", "]"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"subsE", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ToExpression", "[", 
         RowBox[{"fns", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}], "\[Rule]", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<x[\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"i", "-", "1"}], "]"}], "<>", "\"\<]\>\""}], "]"}]}], ",", 
       
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "fns", "]"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"newEqnsUp", "=", 
     RowBox[{
      RowBox[{"ToExpression", "[", "eqnsUp", "]"}], "/.", "subsE"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"eqnsDown", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{"eqnsDown", ",", 
       RowBox[{
       "\"\<HeavisideTheta(-nu + t)\>\"", "\[Rule]", "\"\<HSTemp\>\""}]}], 
      "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"newEqnsDown", "=", 
     RowBox[{
      RowBox[{"ToExpression", "[", "eqnsDown", "]"}], "/.", "subsE"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"lhs", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"\"\<dxdt[\>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"i", "-", "1"}], "]"}], "<>", "\"\<]\>\""}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "newEqnsUp", "]"}]}], "}"}]}], "]"}]}], ";", 
    " ", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
      "same", " ", "for", " ", "both", " ", "up", " ", "and", " ", "down"}], 
      ",", " ", 
      RowBox[{"is", " ", "just", " ", 
       RowBox[{"dxdt", "[", "i", "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"finalEqnsUp", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"lhs", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "<>", "\"\<=\>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"CForm", "[", 
          RowBox[{"newEqnsUp", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], "<>", "\"\<;\>\""}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "lhs", "]"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"finalEqnsDown", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"lhs", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "<>", "\"\<=\>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"CForm", "[", 
          RowBox[{"newEqnsDown", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], "<>", "\"\<;\>\""}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "lhs", "]"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"xReplace", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\"\<x(\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"i", "-", "1"}], "]"}], "<>", "\"\<)\>\""}], "->", 
        RowBox[{"\"\<x[\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"i", "-", "1"}], "]"}], "<>", "\"\<]\>\""}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "fns", "]"}]}], "}"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"restoreHS", "=", 
     RowBox[{"{", 
      RowBox[{"\"\<HSTemp\>\"", "->", "\"\<HeavisideTheta(-nu + t)\>\""}], 
      "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"expSwitchCrap", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "\"\<NonCommutativeMultiply(E,-(t/nu))\>\"", "\[Rule]", 
        "\"\<exp(-t/nu)\>\""}], ",", 
       RowBox[{
       "\"\<NonCommutativeMultiply(E,t/nu)\>\"", "->", 
        "\"\<exp(t/nu)\>\""}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"finalEqnsUp", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{"finalEqnsUp", ",", "xReplace"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"finalEqnsDown", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{"finalEqnsDown", ",", "xReplace"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"finalEqnsDown", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{"finalEqnsDown", ",", 
       RowBox[{"Join", "[", 
        RowBox[{"restoreHS", ",", "expSwitchCrap"}], "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"\"\<CFunctions/\>\"", "<>", "step", "<>", "\"\</B\>\"", "<>", 
       RowBox[{"ToString", "[", "bb", "]"}], "<>", "\"\<K\>\"", "<>", 
       RowBox[{"ToString", "[", "kk", "]"}], "<>", "model", "<>", 
       "\"\<CppUp.txt\>\""}], ",", 
      RowBox[{"Flatten", "[", "finalEqnsUp", "]"}], ",", "\"\<Table\>\""}], 
     "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{
      RowBox[{"\"\<CFunctions/\>\"", "<>", "step", "<>", "\"\</B\>\"", "<>", 
       RowBox[{"ToString", "[", "bb", "]"}], "<>", "\"\<K\>\"", "<>", 
       RowBox[{"ToString", "[", "kk", "]"}], "<>", "model", "<>", 
       "\"\<CppDown.txt\>\""}], ",", 
      RowBox[{"Flatten", "[", "finalEqnsDown", "]"}], ",", "\"\<Table\>\""}], 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"bb", ",", "bMin", ",", "bMax"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"kk", ",", "kMin", ",", "kMax"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.652527082053948*^9, 3.6525271022414722`*^9}, {
   3.652527137812413*^9, 3.652527160828438*^9}, {3.6525287113813667`*^9, 
   3.652528747180998*^9}, {3.652530955125602*^9, 3.652531008533782*^9}, {
   3.652531333677589*^9, 3.652531361926235*^9}, 3.652531397510171*^9, {
   3.652598415530946*^9, 3.6525984184765053`*^9}, {3.6525994649309683`*^9, 
   3.652599470690898*^9}, {3.652603876044763*^9, 3.652603879347794*^9}, {
   3.652604092812208*^9, 3.6526040939879*^9}, {3.652604132140136*^9, 
   3.6526041910438757`*^9}, {3.6526042429882*^9, 3.652604245275962*^9}, {
   3.6526045892043943`*^9, 3.652604591043764*^9}, {3.6526047109963417`*^9, 
   3.652604712847392*^9}, {3.652604803612465*^9, 3.6526048063080397`*^9}, {
   3.652604857260366*^9, 3.652604859379881*^9}, {3.652605475468678*^9, 
   3.652605484075575*^9}, {3.652617163592882*^9, 3.652617429726796*^9}, {
   3.652618410436821*^9, 3.652618485054977*^9}, {3.652620060799736*^9, 
   3.652620063431443*^9}, {3.652621096464604*^9, 3.652621106983795*^9}, {
   3.652622730285096*^9, 3.652622737020434*^9}, {3.652622929788537*^9, 
   3.652622929945372*^9}, {3.652623872929419*^9, 3.6526238763071547`*^9}, {
   3.652693950710141*^9, 3.6526939550165243`*^9}, {3.6526967105195723`*^9, 
   3.652696715940696*^9}, {3.652868461734481*^9, 3.6528684646271753`*^9}, {
   3.6535550505052853`*^9, 3.653555094150405*^9}, {3.653555732731148*^9, 
   3.6535557483997917`*^9}, {3.653719152641251*^9, 3.653719163617181*^9}, {
   3.653888767395671*^9, 3.653888769464959*^9}, {3.6541866850725107`*^9, 
   3.654186730187091*^9}, {3.654186787668379*^9, 3.654186816498028*^9}, {
   3.6541868842969055`*^9, 3.6541868855379767`*^9}, {3.6543407653399343`*^9, 
   3.654340787788871*^9}, {3.6543410248815937`*^9, 3.65434102598426*^9}, {
   3.654341595297922*^9, 3.654341602236774*^9}, {3.654364586662359*^9, 
   3.6543646281897345`*^9}, {3.654400707883235*^9, 3.654400708459268*^9}, {
   3.6544007987324314`*^9, 3.6544008806281157`*^9}, {3.6544009155091105`*^9, 
   3.6544009175562277`*^9}, {3.654577544299466*^9, 3.6545775483787*^9}, {
   3.657347420864689*^9, 3.657347425869809*^9}, {3.657372214321476*^9, 
   3.657372243766644*^9}, {3.657820574499625*^9, 3.657820586404642*^9}, {
   3.657864523205269*^9, 3.657864529754809*^9}, {3.658127330926429*^9, 
   3.6581273353945513`*^9}, {3.658128660594454*^9, 3.6581286681726418`*^9}, {
   3.658221639810525*^9, 3.658221707385812*^9}, {3.6587517112878933`*^9, 
   3.6587517522506332`*^9}, {3.6588189747579813`*^9, 3.658818978778879*^9}, {
   3.658819711489326*^9, 3.658819712728405*^9}, {3.6588203493054667`*^9, 
   3.658820349944952*^9}, {3.6588391873812513`*^9, 3.658839195843707*^9}, {
   3.659100875435453*^9, 3.659100885138955*^9}, {3.6605250806133633`*^9, 
   3.660525137064592*^9}, {3.660859731363725*^9, 3.660859789294039*^9}, {
   3.6621661792933927`*^9, 3.6621662274041443`*^9}, {3.662774593338929*^9, 
   3.66277460611166*^9}, {3.672485960623474*^9, 3.672485961222475*^9}, {
   3.672486246312306*^9, 3.6724862464823065`*^9}, {3.6724864851168766`*^9, 
   3.67248648629688*^9}, {3.6758676335184307`*^9, 3.675867642367937*^9}, {
   3.675878502144351*^9, 3.675878513104978*^9}, {3.675878558362567*^9, 
   3.6758785695852084`*^9}, {3.675878652344942*^9, 3.675878731582474*^9}, {
   3.6766281476788874`*^9, 3.67662814953989*^9}, {3.678269968859882*^9, 
   3.6782699811848993`*^9}, {3.6783689729757547`*^9, 
   3.6783690012803736`*^9}, {3.678370349983836*^9, 3.678370359314849*^9}, {
   3.678897134936413*^9, 3.6788971555125895`*^9}, 3.6788971915936537`*^9, 
   3.6788972342170916`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"CreateDirectory", "::", "filex"}], "MessageName"], ":", 
  " ", "\<\"\[NoBreak]\\!\\(\\\"C:\\\\\\\\Users\\\\\\\\Graeme\\\\\\\\Dropbox\\\
\\\\\\BrduNewPackage\\\\\\\\CFunctions\\\\\\\\\\\"\\)\[NoBreak] already \
exists. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/CreateDirectory\\\", ButtonNote -> \
\\\"CreateDirectory::filex\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6627746068437023`*^9, 3.672485961632498*^9, 3.6724862466173067`*^9, 
   3.6724865086250205`*^9, 3.675867642914968*^9, {3.6758677521772175`*^9, 
   3.675867768515152*^9}, {3.675878555064378*^9, 3.675878569906227*^9}, 
   3.675878601275021*^9, {3.6758786535690117`*^9, 3.675878731875491*^9}, 
   3.6766281631979103`*^9, 3.678269984784904*^9, 3.6782974823078337`*^9, {
   3.6783689789990993`*^9, 3.6783690015963917`*^9}, 3.678369256791988*^9, {
   3.6788971613439236`*^9, 3.678897191928673*^9}, 3.6788972349481335`*^9}],

Cell[BoxData["\<\"C:\\\\Users\\\\Graeme\\\\Dropbox\\\\BrduNewPackage\\\\\
CFunctions\"\>"], "Output",
 CellChangeTimes->{
  3.662774606848702*^9, 3.672485961647498*^9, 3.6724862466273065`*^9, 
   3.6724865086300206`*^9, 3.6758676429219685`*^9, {3.675867752184218*^9, 
   3.6758677685221524`*^9}, {3.675878555072378*^9, 3.675878569913227*^9}, 
   3.675878601283022*^9, {3.6758786535760126`*^9, 3.675878731882491*^9}, 
   3.67662816321791*^9, 3.678269984799904*^9, 3.678297482323835*^9, {
   3.6783689790121*^9, 3.678369001604392*^9}, 3.678369256809989*^9, {
   3.678897161366925*^9, 3.678897191936673*^9}, 3.678897234962134*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"Null", ",", "Null", ",", "Null", ",", "Null", ",", "Null"}], 
   "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.662774606848702*^9, 3.672485961647498*^9, 3.6724862466273065`*^9, 
   3.6724865086300206`*^9, 3.6758676429219685`*^9, {3.675867752184218*^9, 
   3.6758677685221524`*^9}, {3.675878555072378*^9, 3.675878569913227*^9}, 
   3.675878601283022*^9, {3.6758786535760126`*^9, 3.675878731882491*^9}, 
   3.67662816321791*^9, 3.678269984799904*^9, 3.678297482323835*^9, {
   3.6783689790121*^9, 3.678369001604392*^9}, 3.678369256809989*^9, {
   3.678897161366925*^9, 3.678897191936673*^9}, 3.6788972354101596`*^9}]
}, Open  ]]
},
WindowSize->{944, 982},
WindowMargins->{{0, Automatic}, {Automatic, 28}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 122, 2, 32, "Input"],
Cell[CellGroupData[{
Cell[705, 26, 13151, 290, 1396, "Input"],
Cell[13859, 318, 1028, 17, 23, "Message"],
Cell[14890, 337, 627, 9, 32, "Output"],
Cell[15520, 348, 674, 12, 34, "Output"]
}, Open  ]]
}
]
*)

