#include <R.h>
#include <Rmath.h>

void forward_sim(int *nhours, int *dist_normobl, int *dist_retics, 
                 int *dist_rbcs, int *drug_regime, 
                 double *hematocrit, double *retic_percent,
                 double *survival, double *max_production,
                 double *mid_hematocrit, double *steady_state,
                 double *mid_transit, double *hill_coef, int *T_RBC, 
                 int *drug_memory, int *time_lag)
{
  
  int i, t, day;
  int T_m     = 24*5;               // number of hours of maturation of normoblasts
  int T_retic = 4*24;               // Lifespan of a reticulocyte, including marrow and circulating periods
  int lambda  = round((float) 2.56e9/24);  // Normal production rate of normoblasts (cells/kg/hour) 

  int    transit;                   // Release date of retics for a given hematocrit
  double k, s;
  double rho = 1;

  double effect = 0;

  // Variables tracked over time
  double B[*nhours];                // number of circulating mature RBCs
  double R[*nhours];                // number of circulating retics
  
  // Red blood cell distributions
  double erythrocytes[*T_RBC];      // Distribution of erythrocytes in circulation
  double normoblasts[T_m];          // Distribution of normoblasts 
  double reticulocytes[T_retic];
  double temp_circ[*T_RBC];         // for storing, temp vectors
  double temp_marrow[T_m];
  double temp_retics[T_retic];
  
  // initialise our parameters for distribution of RBCs in marrow and circulation
  for(i=0; i < *T_RBC; i++){
    erythrocytes[i] = dist_rbcs[i];
  }
  for(i=0; i< T_m; i++){
    normoblasts[i] = dist_normobl[i];
  }
  for(i=0; i < T_retic; i++){
    reticulocytes[i] = dist_retics[i];
  }
  transit = round( (24*2.56)/(1+exp( (*mid_transit - hematocrit[0])/ *hill_coef ))) + 24;
//  trans_times[0] = transit;
  
  R[0] = 0; B[0] = 0;
  for(i = transit; i < T_retic; i++){ // only count those in circulation (starting at the transit value)
    R[0] += reticulocytes[i];
  }
  for(i=0; i < *T_RBC; i++){
    B[0] += erythrocytes[i];
  }
  retic_percent[0] = 100 * R[0]/(R[0] + B[0]);

  // Simulation for nhours with daily primaquine dose
  for(t=1; t<= *nhours; t++){
    // Compute the multiplication factor of basal normoblast production
    k = log(*max_production -  1)/(*steady_state - *mid_hematocrit);
    rho = *max_production/(1 + exp(k*(hematocrit[t-1] - *mid_hematocrit)));
    
    temp_marrow[0] = normoblasts[0];
    normoblasts[0] = round(rho*lambda);
    for(i = 1; i < T_m; i++){ 
      temp_marrow[i] = normoblasts[i];
      normoblasts[i] = temp_marrow[i-1];
    }
    
    temp_retics[0] = reticulocytes[0];
    reticulocytes[0] = temp_marrow[T_m-1];
    for(i = 1; i < T_retic; i++){ 
      temp_retics[i] = reticulocytes[i];
      reticulocytes[i] = temp_retics[i-1];
    }
    
    temp_circ[0] = erythrocytes[0];
    erythrocytes[0] = temp_retics[T_retic-1];
    if(drug_regime[t] == 1) { // primaquine killing, this is age dependent
      if(*drug_memory < *time_lag) { 
        *drug_memory += 1; 
        effect = (double) *drug_memory/ *time_lag;
        effect = pow( effect , 2);
      } else {
        effect = 1;
      }
      for(i=1; i < *T_RBC; i++){
        temp_circ[i] = erythrocytes[i];
        day = trunc(i/24);
        s = (1-survival[day]) * effect;
        erythrocytes[i] = round( (1-s) * temp_circ[i-1] );
        
      }
    } else { // no killing just normal updating of RBCs
      *drug_memory = 0;
      for(i=1; i < *T_RBC; i++){ 
        temp_circ[i] = erythrocytes[i];
        erythrocytes[i] = temp_circ[i-1];
      }
    }
    R[t] = B[t] = 0;
    for(i = transit; i < T_retic; i++){
      R[t] += reticulocytes[i];
    }
    for(i = 0; i < *T_RBC; i++){
      B[t] += erythrocytes[i];
    }
    hematocrit[t] = hematocrit[0]*(B[t]+R[t])/(B[0]+R[0]);
    retic_percent[t] = 100* R[t]/(R[t] + B[t]);
    transit = round( (24*2.56)/(1+exp( (*mid_transit - hematocrit[t])/ *hill_coef ))) + 24;
//    Rprintf("2 22 2Hello, world!%lf\n",effect);
//    trans_times[t] = transit;
    
  }
  // Copy results onto argument pointers
  // This returns the age distribution of normoblasts; retics; and erythrocytes
  for(i=0; i < T_m; i++){
    dist_normobl[i] = normoblasts[i];
  }
  for(i=0; i < T_retic; i++){
    dist_retics[i] = reticulocytes[i];
  }
  for(i=0; i < *T_RBC; i++){
    dist_rbcs[i] = erythrocytes[i];
  }
  
  
}