function show_incu_radio(fig, ypos, cb)
% support incubator choice as radio boxes in various HARP dialogs

%%(C)%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (C)Jeffrey Hall Lab, Brandeis University.             %%
% Use and distribution of this software is free for academic      %%
% purposes only, provided this copyright notice is not removed.   %%
% Not for commercial use.                                         %%
% Unless by explicit permission from the copyright holder.        %%
% Mailing address:                                                %%
% Jeff Hall Lab, Kalman Bldg, Brandeis Univ, Waltham MA 02454 USA %%
% Email: hall@brandeis.edu                                        %%
%%(C)%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global DAYLIGHTS
global INCUBATOR
global INCU_RADIO

% add incubator choice if daylight included
if ~isempty(DAYLIGHTS)

  uicontrol(fig, ...
	    'Style','text', ...
	    'String','Daylight from incubator:', ...
	    'Position', [20 ypos 150 20], ...
	    'BackgroundColor', get(fig, 'Color'))
  
  INCU_RADIO(1) = uicontrol(fig, ...
	    'Style','radiobutton', ...
	    'String','None', ...
	    'Position', [170 ypos 60 20], ...
	    'BackgroundColor', get(fig, 'Color'), ...
	    'Callback', ...
             sprintf('%s(0)', cb));

  for i = 1:size(DAYLIGHTS,2)
    INCU_RADIO(i+1) = uicontrol(fig, ...
	    'Style','radiobutton', ...
	    'String',num2str(i), ...
	    'Position', [170+i*60 ypos 60 20], ...
	    'BackgroundColor', get(fig, 'Color'), ...
	    'Callback', sprintf('%s(%d)', cb, i));
  end
  
  turnon(INCU_RADIO(INCUBATOR+1))
  
 end

