%Script to reduce analysis time with flytools
%Usage: 
%flyAnalysis(title,
%		number Of The Incubator, 
%		nameMyRun,
%		firstBin,lastBin,
%		firstBinLLDD,lastBinLLDD, 
%		firstHour, 
%		barSize, 
%		channels To Analyze, 
%		peakRange,
%		);
%
% First time you run the function you only need to put "title", "number Of The Incubator" and "nameMyRun" 
% in order to run ralf function and see the data in grafs.
% Then, you run with all the parameters (if you do not need one simply puts 'no' (between simple quotation marks) instead).
% it will run automatically dam_hist, dam_actogram and dam_analyze and save the graf to eps in the same folder.
% 
%Parameter definition.
% if you do not need a parameter put the text 'no' instead.
% title = 'Title'. if you do not want title put 'no' (with single quotation marks).
% numberOfTheIncubator = 1,2,3,4,5 or 6.
% nameMyRun = '*028' %e.g. *026 or F01M026.
% firstBin = 1 -Must be a number.
% lastBin = 0 -Must be a number, if you put 0 it takes the very last one bin.
% firstBinLLDD = must be a number.
% lastBinLLDD = must be number Number if 0 takes the last one.
% firstHour = 6 -must be a number, firstHour according the phase of entrainment.
% barSize = 30 (this changes: barSize and p.int).
% channels To Analyze = e.g [1:15] or [1:15, 18:34] 
% peakRange = e.g. [16 40] Two numbers, put O if you want the default value: [16 32]
%
%%(C)%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (C)Luis Garcia, Polygonal Tree.             		  %%
% Use and distribution of this software is free for academic      %%
% purposes only, provided this copyright notice is not removed.   %%
% Not for commercial use.                                         %%
% Unless by explicit permission from the copyright holder.        %%
% Contact:                                                        %%
% Luis Garcia,													  %%
% Email: luis.garcia@polygonaltree.co.uk   	                      %%
% Website: www.polygonaltree.co.uk                                %%
%%(C)%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function flyAnalysis(title, numberOfTheIncubator, nameToLoad,firstBin,lastBin,firstBinLLDD, lastBinLLDD, firstHour, barSize, fliesInterval, peakRange);

%Parameter definition.
% numberOfTheIncubator = 6
% nameToLoad = '*028' %e.g. *026 or F01M026
% firstBin = 1 % Number
% lastBin = 0 %Number if 0 takes the last one
% firstBinLLDD = number 0 if you do not have a LL or DD period
% lastBinLLDD = number 0 if you do not have a LL or DD period
% firstHour = 6
% barSize = 30
% fliesInterval = [1:15]
% peakRange = [16 40] Two numbers given by [16 40], put O if you want the default value [16 32]




%%Commands

%% If nargin is less than 4 the program only runs "ralf" and print the diagram.
if nargin < 4
	monitor = dam_load(nameToLoad,'.',1,numberOfTheIncubator);
	close(gcf);
	ralf(monitor);
	
	if ~exist('Analysis', 'dir')
  		mkdir('Analysis');
	end
	if (strcmp(title, 'no') == 1)
		title = nameToLoad(2:4);
	end
	set(gcf, 'Position', [0 180 1500 500]);
	set(gcf,'PaperPositionMode', 'auto');
	saveas(gcf, fullfile('./Analysis/',['ralf',title]), 'fig');
	print(gcf, '-depsc', [pwd '/Analysis/ralf',title,'.eps']);
end 

%if nargin is more than 4 it does the rest of the commands.
if nargin > 4

	%Creates the folder Analysis if it is not pressent.
	if ~exist('Analysis', 'dir')
  		mkdir('Analysis');
	end
	if (strcmp(title, 'no') == 1)
		title = nameToLoad(2:4);
	end

	if strcmp(title, 'no') == 1
		title = nameToLoad(2:4);
	end	

	close(gcf);

	monitor = dam_load(nameToLoad,'.',1,numberOfTheIncubator);
	monitorTr = dam_truncate(monitor, firstBin, lastBin,'bins');

	p = dam_hist_par;

	p.firstHour = [firstHour];
	p.barSize = barSize;
	p.int = barSize;

	[avg,sem]=dam_hist(monitorTr,fliesInterval,p);
	
	%set(gcf, 'Position', [0 0 500 500]);
	set(gcf, 'PaperPositionMode', 'auto');
	if (strcmp(title, 'no') == 0)
		suptitle(title);
	end
	print(gcf, '-depsc', [pwd '/Analysis/histogram',title,'.eps']);
	saveas(gcf, fullfile('./Analysis/',['histogram',title]), 'fig');
	close(gcf);

	dam_actogram(monitor,fliesInterval,1);

	if (strcmp(title, 'no') == 0)
		suptitle(title);
	end
	%set(gcf, 'Position', [0 0 1500 500]);
	set(gcf, 'PaperPositionMode', 'auto');
	print(gcf, '-depsc', [pwd '/Analysis/actogram',title,'.eps']);
	saveas(gcf, fullfile('./Analysis/',['actogram', title]), 'fig');
	close(gcf);
end

if nargin > 9 & firstBinLLDD ~= 'no' & lastBinLLDD ~= 'no'
	if peakRange == 'no'
		peakRange =  [16 32];
	end
	monitorTrLLDD = dam_truncate(monitor,firstBinLLDD, lastBinLLDD,'bins');
	pLLDD = dam_analyze_par;
	pLLDD.peakRange = peakRange;
	pLLDD.plotcols = {'acto' 'auto' 'mesa' 'pgram'};
	pLLDD.plotrows = 4;

	if (strcmp(title, 'no') == 0)
		suptitle(title);
	end
	dam_analyze(monitorTrLLDD, 0,fliesInterval,pLLDD);

	if (strcmp(title, 'no') == 0)
		suptitle(title);
	end

	%h = get(0,'children');
	h = findall(0,'Type','figure');
		for i=1:length(h)
			if (strcmp(title, 'no') == 0)
				suptitle(title);
			end
			set(h(i), 'Position', [0 180 1500 500]);
			set(h(i), 'PaperPositionMode', 'auto');
			%set(h(i), 'PaperType', 'A1');
			%set(h(i), 'PaperOrientation', 'landscape');
			print(h(i), '-depsc', [pwd '/Analysis/analyze_',title,'_',num2str(length(h)-i),'.eps']);
  			saveas(h(i), fullfile('./Analysis/',['analyze_',title,'_', num2str(length(h)-i)]), 'fig');
  			close(h(i));
		end
	%print(gcf, '-depsc', ['analyze',title,'.eps']);


end
