
expdir = '/gpfs/gsfs4/users/balderstonnl/startle_meg';
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir)
cd(resdir)
cd sensor

combinedalpha = 0.025;

%thrnames = {'saf.clean.pow.peak', 'saf.clean.pow.alpha', 'saf.clean.pow.gamma', 'saf.clean.str.peak', 'saf.clean.str.alpha'};
statnames = {'ttest.saf-thr.clean.pow.alpha', 'ttest.saf-thr.clean.pow.gamma', 'ttest.saf-thr.clean.pow.peak', 'ttest.saf-thr.clean.str.alpha', 'ttest.saf-thr.clean.str.peak'};


for n=1:length(statnames)

    
    statname = statnames{n};
    
     try
         load(strcat(statname, '.mat'));
     catch
         disp('################################missing files')
     end
    
    
    
        
        cfg = [];
        cfg.zlim = [-5 5];
        cfg.alpha = combinedalpha;
        cfg.style = 'straight';
        cfg.layout = 'CTF275.lay';
        cfg.subplotsize = [1 1];
        
        cfg.saveaspng = strcat(resdir, '/', statname, '.pos.png');
        ft_clusterplot(cfg,stat)
        close ALL HIDDEN
        
        stat.stat = stat.stat*-1;
        cfg.saveaspng = strcat(resdir, '/', statname, '.neg.png');
        ft_clusterplot(cfg,stat)
        close ALL HIDDEN
end
