function check_alignment_mri_meg(expdir,subject)

%% runs function to setup the environment for the experiment
if nargin < 2
    subject = [];
end;
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject);
%% 

disp('################################load data')
cd(anatpath);
load('vol_ctf.mat');
load('sourcemodel_grid.mat');

disp('################################load data')
cd(dspath);
fnames = dir('*.preproc.mat');
time = [];
load(fnames(1).name);
grad = data.grad;

disp('################################plot results')
figure; hold on;
ft_plot_vol(vol_ctf, 'edgecolor', 'none', 'facecolor', [0.95 0.95 0.95]);
camlight
ft_plot_mesh(sourcemodel_grid.pos, 'vertexcolor', [1 0.5 0]);
ft_plot_mesh(sourcemodel_grid.pos(sourcemodel_grid.inside,:), 'vertexcolor', [0.5 1 0]);
ft_plot_sens(grad);



alignmentstr = input('does the alignment look good? hit enter for yes:', 's')



if isempty(alignmentstr)
    titlestr = 'yes';
else
    titlestr = alignmentstr;
end;




disp('################################save figure')
figfname = strcat(subject, '.alignment.', titlestr, '.png');
title(titlestr);
saveas(gcf, figfname);


exit