function check_covariance_svd(expdir,subject)

%% runs function to setup the environment for the experiment
if nargin < 2
    subject = [];
end;
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)
%%

try
    
cd(dspath)
titlestr = strcat(subject, '.svd.scree.plot');
figfname = strcat(titlestr, '.png');
lambda = 0.05;


disp('################################dirty timelocked')
cfg = [];
cfg.vartrllength = 2;
cfg.covariance = 'yes';
cfg.covariancewindow = 'prestim';
cfg.channel = 'MEG';
cfg.inputfile = strcat(subject, '.alltrials.mat');
timelock = ft_timelockanalysis(cfg);

[u,s,v] = svd(timelock.cov);
premax = log(max(s))';

disp('################################clean timelocked')
cfg = [];
cfg.vartrllength = 2;
cfg.covariance = 'yes';
cfg.covariancewindow = 'prestim';
cfg.channel = 'MEG';
cfg.inputfile = strcat(subject, '.alltrials.clean.mat');
timelock = ft_timelockanalysis(cfg);

[u,s,v] = svd(timelock.cov);
postmax = log(max(s))';

covsort = sort(reshape(abs(timelock.cov), 1, []));
mu = covsort(round(length(covsort)*lambda))


[u,s,v] = svd(timelock.cov + mu * eye(size(timelock.cov,1)));
postnormal = log(max(s))';


disp('################################save figure')
clear gcf;
figure; hold on;
title(titlestr);
a1 = plot(premax);
a2 = plot(postmax);
a3 = plot(postnormal);
l1 = 'PreICA';
l2 = 'PostICA';
l3 = 'PostICAnormalized';
legend(l1, l2, l3);
saveas(gcf, figfname);

catch
    exit
end

exit
