function freq_statistic_meg(expdir)

%% runs function to setup the environment for the experiment
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir)
%%

disp('################################load template')
mri = ft_read_mri(fullfile(ft_home, '/template/anatomy/single_subj_T1.nii'));

perms = 1000;
alpha = 0.005;
combinedalpha = 0.025;
%fbands = {'delta', 'theta', 'alpha', 'beta', 'gamma', 'peak'};
fbands = {'peak'};
stats = {'pow', 'anx', 'str', 'avg'};
trialvals = [8 16];
triallabels = {'thr', 'saf'};



disp(strcat('################################prepare neighbors'));
cfg = [];
cfg.method = 'template';
cfg.template = 'CTF275_neighb.mat';
cfg.channel = 'MEG';
neighbors = ft_prepare_neighbours(cfg);

for f=1:length(fbands)
    for k=1:length(stats)
        cd(resdir)
        
             

        
        saflabel = triallabels{2};
        thrlabel = triallabels{1};

        disp(strcat('################################load ', saflabel));
        clear fnames files;
        fnames = ls(strcat(subdir, '/*/*/*', saflabel, '.clean.', stats{k}, '.', fbands{f}, '.mat'))
        files = strsplit(fnames,'\n');
        files(strcmp('',files)) = [];

        cfg = [];
        cfg.parameter = 'powspctrm';
        cfg.keepindividual = 'yes';
        cfg.inputfile = files;
        saf = ft_freqgrandaverage(cfg);
        saf.dim = template.sourcemodel.dim;

        
        disp(strcat('################################load ', thrlabel));
        clear fnames files;
        fnames = ls(strcat(subdir, '/*/*/*', thrlabel, '.clean.', stats{k}, '.', fbands{f}, '.mat'))
        files = strsplit(fnames,'\n');
        files(strcmp('',files)) = [];

        cfg = [];
        cfg.parameter = 'powspctrm';
        cfg.keepindividual = 'yes';
        cfg.inputfile = files;
        thr = ft_freqgrandaverage(cfg);
        thr.dim = template.sourcemodel.dim;
        
        disp('################################calculate design matrix')
        subj = size(saf.powspctrm,1);
        design = zeros(2,2*subj);
        for i = 1:subj
            design(1,i) = i;
        end
        for i = 1:subj
            design(1,subj+i) = i;
        end
        design(2,1:subj) = 1;
        design(2,subj+1:2*subj) = 2;
        
        disp('################################run stats')
        cfg = [];
        cfg.avgoverfreq = 'yes';
        cfg.neighbours = neighbors;
        cfg.parameter = 'powspctrm';
        cfg.statistic = 'ft_statfun_depsamplesT';
        cfg.parameter = 'powspctrm';
        cfg.computeprob = 'yes';
        cfg.design = design;
        cfg.uvar = 1;
        cfg.ivar = 2;
        cfg.method = 'montecarlo';
        cfg.numrandomization = perms;
        cfg.correctm = 'cluster';
        cfg.clusterstatistic = 'maxsum';
        cfg.clusterthreshold = 'parametric';
        cfg.tail = 0;
        cfg.clustertail = 0;
        cfg.correcttail = 'alpha';
        cfg.alpha = combinedalpha;
        cfg.clusteralpha = alpha;
        cfg.outputfile = strcat(resdir, '/', 'ttest.saf-thr.clean.', stats{k}, '.', fbands{f}, '.mat');
        stat = ft_freqstatistics(cfg, saf, thr);
        
        
        
        cfg = [];
        cfg.zlim = [-5 5];
        cfg.alpha = combinedalpha;
        cfg.layout = 'CTF275.lay';
        cfg.saveaspng = strcat(resdir, '/', 'ttest.saf-thr.clean.', stats{k}, '.', fbands{f});
        cfg.subplotsize = [12 20];
        ft_clusterplot(cfg,stat)
        
    end;
end;

reqlicense = license('inuse')
save(strcat(scrdir, '/', 'freq_statistic_meg.reqlicense.mat'), 'reqlicense');
