function preprocess_meg(expdir,subject)

%% runs function to setup the environment for the experiment
if nargin < 2
    subject = [];
end;
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)
%%

diaryfile = strcat(logdir, '/', subject, '.preprocess_meg.diary.txt');
errorfile = strcat(logdir, '/', subject, '.preprocess_meg.error.txt');

diary(diaryfile);

try
    cd(dspath)
    load(strcat(subject, '.trialinfo.mat'));
    trialinfo = [alltrialinfo(:,4:6), anxrating(:,4), startle];
    
    fnames = dir('*-c.ds');
    for i = 1:length(fnames)
        try
            ds = fnames(i).name;
            trl = [];
            
            disp('################################ft_definetrial')
            cfgtmp = [];
            cfgtmp.dataset = ds;
            cfgtmp.trialdef.prestim = 2;
            cfgtmp.trialdef.poststim = 0;
            cfgtmp.trialdef.eventtype = 'SAF';
            cfgtmp = ft_definetrial(cfgtmp);
            cfgtmp.trl(:,4) = 16;
            cfgtmp.trl(:,5) = i;
            cfgtmp.trl(:,6) = linspace(1,length(cfgtmp.trl),length(cfgtmp.trl));
            cfgtmp.trl(:,7) = trialinfo(find(trialinfo(:,1) == 16 & trialinfo(:,2) == i),4);
            cfgtmp.trl(:,8) = trialinfo(find(trialinfo(:,1) == 16 & trialinfo(:,2) == i),5);
           
            trl = [trl; cfgtmp.trl];
            
            cfgtmp = [];
            cfgtmp.dataset = ds;
            cfgtmp.trialdef.prestim = 2;
            cfgtmp.trialdef.poststim = 0;
            cfgtmp.trialdef.eventtype = 'THR';
            cfgtmp = ft_definetrial(cfgtmp);
            cfgtmp.trl(:,4) = 8;
            cfgtmp.trl(:,5) = i;
            cfgtmp.trl(:,6) = linspace(1,length(cfgtmp.trl),length(cfgtmp.trl));
            cfgtmp.trl(:,7) = trialinfo(find(trialinfo(:,1) == 8 & trialinfo(:,2) == i),4);
            cfgtmp.trl(:,8) = trialinfo(find(trialinfo(:,1) == 8 & trialinfo(:,2) == i),5);
            trl = [trl; cfgtmp.trl];
            
            
            % %trials
            cfg = [];
            cfg.dataset = ds;
            cfg.trl = trl;
            cfg.demean = 'yes';
            cfg.detrend = 'yes';
            cfg.baselinewindow = [-2 0];
            clear cfgtmp;
            clear trl;
            
            
            disp('################################ft_preprocessing')
            data = ft_preprocessing(cfg);
            
            disp('################################ft_denoise_synthetic')
            cfg.gradient = 'G3BR';
            data = ft_denoise_synthetic(cfg,data);
            
            disp('################################ft_rejectartifact')
            %     cfg.artfctdef.muscle.interactive = 'yes';
            cfg.artfctdef.muscle.cutoff = 20;
            cfg = ft_artifact_muscle(cfg)
            cfg = ft_rejectartifact(cfg);
            
            
            disp('################################ft_preprocessing')
            cfg.lpfilter = 'yes';
            cfg.dftfilter = 'yes';
            cfg.lpfreq = 90;
            cfg.dftfreq = [60 120 180];
            data = ft_preprocessing(cfg);
            
            disp('################################ft_resampledata')
            cfg.resamplefs = 300;
            cfg.outputfile = strcat(subject, '.', num2str(i), '.preproc.mat');
            data = ft_resampledata(cfg, data);
        catch
            disp('################################no trials')
        end
        
    end
    
    
    
    disp('################################ft_resampledata')
    fnames = dir('*.preproc.mat');
    for i = 1:length(fnames)
        dsarray{i} = fnames(i).name;
    end
    
    cfg = [];
    cfg.inputfile = dsarray;
    cfg.outputfile = strcat(subject, '.alltrials.mat')
    data = ft_appenddata(cfg);
    
    save(strcat(dspath, '/', subject, '.trialinfo.clean.mat'), 'trialinfo' )

    
    disp('################################ft_componentanalysis')
    cfg = [];
    cfg.channel = 'MEG';
    cfg.method = 'runica';
    cfg.outputfile = strcat(subject, '.components.mat')
    comp = ft_componentanalysis(cfg, data);
    
    
    reqlicense = license('inuse')
    save(strcat(scrdir, '/', 'preprocess_meg.reqlicense.mat'), 'reqlicense');
catch
    exit
    reqlicense = license('inuse')
    save(strcat(scrdir, '/', 'preprocess_meg.reqlicense.mat'), 'reqlicense');
    diary off;
    movefile(diaryfile, errorfile);
end

diary off;
exit
