function preprocess_mri(expdir,subject)

%% runs function to setup the environment for the experiment
if nargin < 2
    subject = [];
end;
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)
%%

    cd(anatpath);
    cd ..
    
    
    disp('################################load mri')
    cfg = [];
    mri = ft_read_mri('mri/orig.mgz');
    mri.coordsys = 'rai';
    
    disp('################################warp to mni space')
    cfg = [];
    cfg.nonlinear = 'no';
    mri_mni = ft_volumenormalise(cfg, mri);

    disp('################################warp mri to ctf space')
    cfg = [];
    cfg.method  = 'interactive';
    cfg.coordsys = 'ctf';
    mri_ctf = ft_volumerealign(cfg, mri_mni);
    mri_ctf = ft_convert_units(mri_ctf, 'cm');
    
    disp('################################save data')
    save(strcat(anatpath, '/', 'mri_mni.mat'), 'mri_mni');
    save(strcat(anatpath, '/', 'mri_ctf.mat'), 'mri_ctf');
    save(strcat(anatpath, '/', 'sourcemodel_mni.mat'), 'sourcemodel_mni');
    
    reqlicense = license('inuse')
    save(strcat(scrdir, '/', 'preprocess_mri.reqlicense.mat'), 'reqlicense');
    
