function process_dics_correlation_compile(expdir,subject,fbands)

[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)
disp('################################setup')
trialvals = [8 16];
triallabels = {'thr', 'saf'};
trialinfolabels = {'cond', 'run', 'trial', 'anx', 'str', 'avg'};

disp('################################load anat')
cd(anatpath);
load('leadfield_ctf.mat');
load('vol_ctf.mat');
load('sourcemodel_ctf.mat');
mri = ft_read_mri('mri_mni.mat');


disp('################################load data')
cd(dspath);
fnames = dir('*.preproc.mat');
time = [];
load(fnames(1).name);
grad = data.grad;

%%
disp('################################load filter')
cd(dspath);
load(strcat(subject, '.', fbands, '.', '.commonfilter.mat'));
%%

for i = 1:length(trialvals)
    
    %%
    disp('################################load data')
    cd(dspath);
    load(strcat(subject, '.', triallabels{i}, '.clean.pow.', fbands, '.mat'));
    trialinfo.(triallabels{i}) = freq.trialinfo;
    trialinfo.(triallabels{i})(:,4) = zscore(freq.trialinfo(:,4))*-1;
    trialinfo.(triallabels{i})(:,5) = zscore(freq.trialinfo(:,5));
    trialinfo.(triallabels{i})(:,6) = mean(freq.trialinfo(:,4:5),2);
    trialselection = find(trialinfo.(triallabels{i})(:,1) == trialvals(i));
    %%
    
    %%
    for t = 1:length(trialselection)
        disp(strcat('################################do source analysis', triallabels{i}))
        cfg = [];
        cfg.method = 'dics';
        cfg.grid = leadfield_ctf;
        cfg.headmodel = vol_ctf;
        cfg.grad = grad;
        cfg.grid.filter = commonfilter;
        cfg.channel = 'MEG';
        cfg.dics.lambda = '5%';
        cfg.dics.fixedori = 'yes';
        source = ft_sourceanalysis(cfg, freq);
        indices = find(source.inside);
        dat.(triallabels{i})(t,:) = source.avg.pow(indices);
    end
    %%
    
    %%
    for j=4:6
        
        design = zscore(trialinfo.(triallabels{i})(:,j));
        for l=1:length(dat.(triallabels{i})(1,:))
            [b,dev,stats] = glmfit(design,dat.(triallabels{i})(:,l));
            bstat(:,l) = stats.beta;
        end
        source.avg.pow = zeros(size(source.avg.pow));
        source.avg.pow(indices) = bstat(2,:);
        source.pos = template.sourcemodel.pos;
        save(strcat(subject, '.', triallabels{i}, '.clean.', trialinfolabels{j}, '.', fbands, '.mat'), 'source');
        
        mri = ft_read_mri(fullfile(ft_home, '/template/anatomy/single_subj_T1.nii'));
        parameters = {'pow'};
        
        disp('################################interpolating sources')
        cfg = [];
        cfg.downsample = 1;
        cfg.parameter = parameters;
        cfg.interpmethod = 'nearest';
        sourcestat = ft_sourceinterpolate(cfg, source, mri);
        
        for l=1:length(parameters)
            
            disp(strcat('################################writing', ' ', parameters{l}))
            cfg = [];
            cfg.filename = strcat(subject, '.', triallabels{i}, '.clean.', trialinfolabels{j}, '.', fbands, '.nii');
            cfg.filetype = 'nifti';
            cfg.parameter = parameters{l};
            cfg.precision = 'double';
            ft_sourcewrite(cfg, sourcestat);
            
        end
        
    end
    %%
end

%%
% 
%     
% for j=4:6
%     dat.bth = [dat.(triallabels{1})(:,j); dat.(triallabels{2})(:,j)];
%     design = [trialinfo.(triallabels{1})(:,j);trialinfo.(triallabels{2})(:,j)];
%     for l=1:length(dat.bth(:,1))
%         [b,dev,stats] = glmfit(design,dat.bth(l,:)');
%         bstat(:,l) = stats.beta;
%     end
%     source.avg.pow = zeros(size(source.avg.pow));
%     source.avg.pow(indices) = bstat(2,:);
%     source.pos = template.sourcemodel.pos;
%     save(strcat(subject, '.', 'bth', '.clean.', trialinfolabels{j}, '.', fbands, '.mat'), 'source');
%     
%     mri = ft_read_mri(fullfile(ft_home, '/template/anatomy/single_subj_T1.nii'));
%     parameters = {'pow'};
%     
%     disp('################################interpolating sources')
%     cfg = [];
%     cfg.downsample = 1;
%     cfg.parameter = parameters;
%     cfg.interpmethod = 'nearest';
%     sourcestat = ft_sourceinterpolate(cfg, source, mri);
%     
%     for l=1:length(parameters)
%         
%         disp(strcat('################################writing', ' ', parameters{l}))
%         cfg = [];
%         cfg.filename = strcat(subject, '.', 'bth', '.clean.', trialinfolabels{j}, '.', fbands, '.nii');
%         cfg.filetype = 'nifti';
%         cfg.parameter = parameters{l};
%         cfg.precision = 'double';
%         ft_sourcewrite(cfg, sourcestat);
%         
%     end
%     
% end
% %%
