function process_freq_correlation_peak_allsubs(expdir)

[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir)
cd(subdir)

subs = dir(subdir);
for k = 3:length(subs)
    cd(matdir)
    subject = subs(k).name
    [ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)
    
    trialvals = [8 16];
    triallabels = {'thr', 'saf'};
    fbands = {'peak'};
 %   fbands = {'delta', 'theta', 'alpha', 'beta', 'gamma', 'peak'};
    trialinfolabels = {'cond', 'run', 'trial', 'anx', 'str', 'avg'};
    for f = 1:length(fbands)
        
        for i = 1:length(trialvals)
            
            for j=4:6
                disp('################################load data')
                cd(dspath);
                load(strcat(subject, '.', triallabels{i}, '.clean.pow.', fbands{f}, '.mat'));
                
                
                
                
                disp('################################create source timecourse')
                freqave = mean(freq.powspctrm,3)';
                freq.trialinfo(:,4) = zscore(freq.trialinfo(:,4))*-1;
                freq.trialinfo(:,5) = zscore(freq.trialinfo(:,5));
                freq.trialinfo(:,6) = mean(freq.trialinfo(:,4:5),2);
                dat = freqave;
                
                
                design = zscore(freq.trialinfo(:,j));
                for l=1:length(dat(:,1))
                    [b,dev,stats] = glmfit(design,dat(l,:)');
                    bstat(:,l) = real(stats.beta);
                end
                powspctrm = bstat(2,:);
                
                freq.freq = mean(freq.freq);
                freq.dimord = 'chan_freq';
                freq.powspctrm = powspctrm';
                fields = {'labelcmb', 'crsspctrm', 'trialinfo'};
                freq = rmfield(freq, fields);
                
                save(strcat(subject, '.', triallabels{i}, '.clean.freq', trialinfolabels{j}, '.', fbands{f}, '.mat'), 'freq');
                
                
            end
            
        end
        
    end
end
