function [ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)



%% 
% This function sets up the environment for your script
%% 


%% set fieldtrip defaults
if ~isdeployed
restoredefaultpath;
addpath /home/balderstonnl/matlab/fieldtrip;
end

ft_home = '/home/balderstonnl/matlab/fieldtrip';
ft_defaults;
disp('################################load template')
template = load(fullfile(ft_home, '/template/sourcemodel/standard_sourcemodel3d8mm'));
%template = 'not loaded';
%% 

%% setup experiment environment
subdir = strcat(expdir, '/data');
mridir = strcat(expdir, '/anat');
scrdir = strcat(expdir, '/SCRIPTS');
logdir = strcat(expdir, '/logs');
resdir = strcat(expdir, '/results');
stmdir = strcat(expdir, '/stimtimes');
emgdir = strcat(expdir, '/startle');
matdir = strcat(expdir, '/mfiles');
%% 

%% setup subject data environment
try
    subpath = strcat(subdir, '/', subject);
    cd(subpath);
    dirlist = dir('2*');
    dsdir = dirlist.name;
    dspath = strcat(subpath, '/', dsdir);
    cd(dspath);
catch
    dspath = [];
end;
%% 

%% setup subject anatomy environment
try
    anatpath = strcat(mridir, '/', subject, '/', 'fieldtrip');
    cd(anatpath);
catch
    anatpath = [];
end;
cd(matdir);
%%
