#!/bin/tcsh
setenv expdir `dirname $PWD`
setenv outfile `basename $0`
setenv subdir ${expdir}/data
setenv mridir ${expdir}/anat
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv resdir ${expdir}/results
setenv stmdir ${expdir}/stimtimes
setenv emgdir ${expdir}/startle
setenv matdir ${expdir}/mfiles
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv mrisubs `ls ${mridir}`
setenv mrisubnum `ls ${mridir} | wc -l`

setenv swarmlicenses matlab,matlab-signal,matlab-image
setenv swarmmodules afni,python,matlab/2015a
setenv infname d04.preprocess_meg.csh

foreach subject (${subs})


setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}
setenv infile ${logdir}/${infname}.${subject}

if (-e ${infile}) then
if (-e ${logfile}) then 
	echo "this script has been run for subject $subject"
else


#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${matdir}
matlab -r "reject_components_meg('${expdir}','${subject}')"



#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile}" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end

#####run swarm command
cd $scrdir
chmod a+rwx ${swarmfile}
$swarmfile
#swarm -t 2 -g 4 -module afni,python,matlab/2015a --license=matlab -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
