#!/bin/tcsh
setenv expdir `dirname $PWD`
setenv outfile `basename $0`
setenv subdir ${expdir}/data
setenv mridir ${expdir}/anat
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv resdir ${expdir}/results
setenv stmdir ${expdir}/stimtimes
setenv emgdir ${expdir}/startle
setenv matdir ${expdir}/mfiles
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv mrisubs `ls ${mridir}`
setenv mrisubnum `ls ${mridir} | wc -l`

setenv swarmlicenses matlab,matlab-signal,matlab-image
setenv swarmmodules afni,python,matlab/2015a
setenv infname1 d06.preprocess_mri.csh


foreach subject (${mrisubs})

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv swarmfileser ${scrdir}/rm.${outfile}.swarmser
setenv logfile ${logdir}/${outfile}.${subject}
setenv infile1 ${logdir}/${infname1}.${subject}

if (-e ${infile1}) then
if (-e ${logfile}) then 
	echo "this script has been run for subject $subject"
else


#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${matdir}
matlab -nosplash -nojvm -nodesktop -r "process_forward_model_mri('${expdir}','${subject}')"

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile}" >> ${swarmfile}

endif
else
	echo "please run ${infile1} for $subject"
endif
end

#####run swarm command
cd $scrdir
chmod a+rwx ${swarmfile}
echo "tcsh -c ${swarmfile}" >> ${swarmfileser}

#swarm -t 2 -g 4 -module ${swarmmodules} --license=${swarmlicenses} -f ${swarmfile}
swarm -t 4 -g 20 --time=72:00:00 -module ${swarmmodules} --license=${swarmlicenses} -f ${swarmfileser}

#####remove swarm file
#rm ${swarmfile}
#rm ${swarmfileser}
