#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`



echo "set files"
cd $subdir
setenv saffiles `ls ???/*/???.saf.clean.dics.*peak*.2mm.nii`
setenv thrfiles `ls ???/*/???.thr.clean.dics.*.2mm.nii`

echo "set mask"
cd $resdir
setenv masks `ls *peak*clusterslabelmat.nii`


echo "foreach loops"
foreach mask ($masks)
foreach fname (${saffiles} ${thrfiles})


echo "set individual files"
setenv statsfile ${resdir}/rm.${outfile}.${mask}.1D
setenv maskfile ${resdir}/${mask}
setenv datafile ${subdir}/${fname}


3dROIstats \
-mask ${maskfile} \
$datafile \
| tee -a ${statsfile}

end
end

paste `ls ${resdir}/rm.${outfile}*` > ${resdir}/${outfile}.${subnum}_subs.1D

rm ${resdir}/rm*

