#!/bin/tcsh
setenv expdir `dirname $PWD`
setenv outfile `basename $0`
setenv subdir ${expdir}/data
setenv mridir ${expdir}/anat
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv resdir ${expdir}/results
setenv stmdir ${expdir}/stimtimes
setenv emgdir ${expdir}/startle
setenv matdir ${expdir}/mfiles
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv mrisubs `ls ${mridir}`
setenv mrisubnum `ls ${mridir} | wc -l`

cd $resdir

#foreach file (`ls *nii`)

#set fbase=`basename $file .nii`


#3dAllineate \
#-base MNI_avg152T1+tlrc \
#-1Dmatrix_save $fbase.stat.warp_2_mni.1D \
#-source $fbase.nii \
#-warp shift_rotate_scale \
#-prefix $fbase.scale.nii

#end


foreach posfile (`ls *.posclusterslabelmat.nii`)

set fbase=`basename $posfile .posclusterslabelmat.nii`
echo $fbase

3dcalc \
-a $fbase.stat.nii \
-b $fbase.posclusterslabelmat.nii \
-c MNI_avg152T1+tlrc \
-expr "a*step(b)*step(c)" \
-prefix $fbase.stat.pos.mask.nii 


end




foreach negfile (`ls *.negclusterslabelmat.nii`)

set fbase=`basename $negfile .negclusterslabelmat.scale.nii`


3dcalc \
-a $fbase.stat.nii \
-b $fbase.negclusterslabelmat.nii \
-c MNI_avg152T1+tlrc \
-expr "a*step(b)*step(c)" \
-prefix $fbase.stat.neg.mask.nii 


end

