#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv outfile `basename $0`
setenv subs `ls ${subdir}`

foreach subject (${subs})
foreach mrdir (`ls ${subdir}/${subject} | grep mr`)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${mrdir}
setenv infile ${logdir}/00.tar.csh.${subject}

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

cd ${subdir}/${subject}/${mrdir}

set prefix=`ls *dcm | head -n 1 | cut -d_ -f1`
set echotime=`more README-Series.txt | grep "Echo Time" | cut -d: -f2 | tr -d " "`

#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}/${mrdir}

echo "$echotime" > ${subject}.${prefix}.${echotime}.echotime
Dimon -infile_pattern '*.dcm' -gert_create_dataset -gert_quit_on_err -gert_to3d_prefix ${subject}.${prefix}.${echotime}

mv ${subject}.${prefix}.${echotime}* ${subdir}/${subject}

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end

#####run swarm command
swarm -R gpfs -t 2 -g 4 -module afni python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
