#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv subs `ls ${subdir}`

foreach subject (${subs})
foreach run (run1 run2 run3 run4)

waver -GAM -TR 2 -peak 1 -input ${stmdir}/${subject}.${run}.dial.1D > ${stmdir}/rm.${subject}.${run}.dial.hrf.1D
waver -GAM -TR 2 -peak 1 -input ${stmdir}/${subject}.${run}.shock.1D > ${stmdir}/rm.${subject}.${run}.shock.hrf.1D
waver -GAM -TR 2 -peak 1 -input ${stmdir}/${subject}.${run}.transitions.1D > ${stmdir}/rm.${subject}.${run}.transitions.hrf.1D

head -n 245 ${stmdir}/rm.${subject}.${run}.dial.hrf.1D > ${stmdir}/${subject}.${run}.dial.hrf.1D
head -n 245 ${stmdir}/rm.${subject}.${run}.shock.hrf.1D > ${stmdir}/${subject}.${run}.shock.hrf.1D
head -n 245 ${stmdir}/rm.${subject}.${run}.transitions.hrf.1D > ${stmdir}/${subject}.${run}.transitions.hrf.1D

rm rm.*

1dBport \
-nodata 245 2 \
-band 0.01 0.1 \
-invert \
-nozero \
> ${stmdir}/${subject}.${run}.bandpass.1D

end

cd ${subdir}/${subject}

echo "# make a single file of registration params for $subject"
cat ${stmdir}/${subject}.run?.bandpass.1D > ${stmdir}/${subject}.bandpass.1D

cat meica.${subject}.run?.12/motion.1D > ${stmdir}/${subject}.dfile_rall.1D
cat ${stmdir}/${subject}.run?.dial.hrf.1D > ${stmdir}/${subject}.dial.1D
cat ${stmdir}/${subject}.run?.shock.hrf.1D > ${stmdir}/${subject}.shock.1D
cat ${stmdir}/${subject}.run?.transitions.hrf.1D > ${stmdir}/${subject}.transitions.1D

echo "# compute de-meaned motion parameters (for use in regression) for $subject"
1d_tool.py \
-infile ${stmdir}/${subject}.dfile_rall.1D \
-set_nruns 4 \
-demean \
-overwrite \
-write ${stmdir}/${subject}.motion.1D

1d_tool.py \
-infile ${stmdir}/${subject}.dfile_rall.1D \
-set_nruns 4 \
-show_censor_count \
-censor_prev_TR \
-overwrite \
-censor_motion 0.5 \
${stmdir}/${subject}

end
