#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv outfile `basename $0`
setenv subs `ls ${subdir}`

foreach subject (${subs})
foreach run (forward reversed)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${run}
setenv infile ${logdir}/f03.align_epi2anat.csh.${subject}.run1

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

cd ${subdir}/${subject}

set e=""
foreach echotimefname ( `ls ${subject}.${run}.*.echotime` )
set e=($e `more $echotimefname`)
end


#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}

#pull out first subbrick of blip
3dMean \
-prefix ${subject}.${run}.index \
${subject}.${run}.12+orig'[1]' \
${subject}.${run}.24.48+orig'[1]' \
${subject}.${run}.36.96+orig'[1]'

#skullstrip blip
3dSkullStrip \
-prefix ${subject}.${run}.strip \
-input ${subject}.${run}.index+orig

#align blips to runs
3dAllineate \
-warp shift_rotate \
-1Dparam_save ${subject}.${run}.strip.1Dparam.1D \
-base ${subject}.run1.mean_al+orig \
-source ${subject}.${run}.strip+orig \
-prefix ${subject}.${run}.strip_al

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end

#####run swarm command
swarm -R gpfs -t 2 -g 4 -module afni python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}


