#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`


foreach subject (${subs})
foreach cond (thr saf)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${cond}
setenv infile ${logdir}/f05.3ddeconvolve.csh.${subject}

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}





3dTcat \
-prefix $subject.residuals.${cond}.clean+orig \
$subject.residuals+orig'[1dcat ${stmdir}/${subject}.${cond}.clean.trs.1D]' 






#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end

#####run swarm command
swarm -R gpfs -t 2 -g 6 -module afni python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
