#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`

mkdir ${resdir}/blur_estimate

foreach subject (${subs})
foreach cond (saf thr)
setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${cond}

if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}
echo "##############################3dfwhm $subject"


3dFWHMx \
-detrend \
-acf ${resdir}/blur_estimate/${subject}.${cond}.qwarp.acs.1D \
-input ${subject}.residuals.${cond}.clean.qwarp.blur.group+tlrc \
| tee ${resdir}/blur_estimate/${subject}.${cond}.qwarp.blur.1D \




#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
end
end

cd $scrdir
#####run swarm command
chmod a+rwx ${swarmfile}
#${swarmfile}
swarm -t 2 -g 6 -module afni,python,freesurfer --time=48:00:00 -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}





