#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`


setenv statsfile ${outfile}.1D
setenv mask wb.3dtcorr1d.both.1_mask.nii

cd $resdir
rm $statsfile

foreach subject (${subs})
foreach cond (thr saf)

echo "$subject $cond" | tee -a rm.${statsfile}

3dROIstats \
-mask ${mask} \
${subdir}/${subject}/${subject}.${cond}.both.3dtcorr1d.z.nii \
| tee -a ${statsfile}

end
end

