#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv tvalue 6
mkdir ${resdir}/${subnum}_subs





############################################
#
#
#be sure to run this after
#running the group level ICA
#
#
############################################







cd ${resdir}

echo "##########################calc"
3dcalc \
-a ica.tscores.nii \
-expr 'abs(a)' \
-prefix ica.tscores.abs.nii

3dmerge \
-doall \
-1clip ${tvalue} \
-prefix ica.tscores.thresh.nii \
ica.tscores.abs.nii


echo "##########################tstat"
3dTstat \
-argmax \
-prefix ica.tscores.rank.nii \
ica.tscores.thresh.nii

foreach subbrick (1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25)


echo "##########################calc ${subbrick}"
3dcalc \
-a ica.tscores.rank.nii \
-expr "amongst(${subbrick},a)*a" \
-prefix ica.tscores.rank.${subbrick}.nii


echo "##########################merge ${subbrick}"
3dclust \
-savemask rm.ica.tscores.rank.mask.${subbrick}.nii \
-1Dformat \
-nosum \
-1noneg \
-1dindex 0 \
-1tindex 0 \
-1thresh .9 \
-dxyz=1 1.44 80 \
ica.tscores.rank.${subbrick}.nii > \
ica.tscores.rank.mask.${subbrick}.clust_table.1D

3dcalc \
-a ica.tscores.rank.${subbrick}.nii \
-b rm.ica.tscores.rank.mask.${subbrick}.nii \
-expr "a*100*step(b) + b" \
-prefix ica.tscores.rank.mask.${subbrick}.nii

end


3dMean \
-nscale \
-sum \
-prefix ica.tscores.rank.mask.combine.nii \
`ls ica.tscores.rank.mask.*.nii`

rm rm*

