function process_beamformer_fbands(expdir,subject)


[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)
%%


disp('################################load anat')
cd(anatpath);
load('leadfield_ctf.mat');
load('vol_ctf.mat');
load('sourcemodel_ctf.mat');
mri = ft_read_mri('mri_mni.mat');


disp('################################load data')
cd(dspath);
fnames = dir('*.preproc.mat');
time = [];
load(fnames(1).name);
grad = data.grad;
load(strcat(subject, '.alltrials.clean.mat'));

disp('################################do freq analysis to find peak')
cfg = [];
cfg.channel = 'MEG';
cfg.output = 'pow';
cfg.method = 'mtmfft';
cfg.taper = 'dpss';
cfg.keeptrials = 'yes';
cfg.foilim = [1 20];
cfg.tapsmofrq = 1;
freq = ft_freqanalysis(cfg, data);


try
    [peaks, locs, widths, proms] = findpeaks(avefreq, freq.freq);
    [maxproms locproms] = max(proms);
    peak = locs(locproms)
    
    if (peak < 8) || (peak > 12)
        disp('################################no major alpha peak')
        peak = 10;
    end
    
catch
    disp('################################peak finder failed')
    peak = 10;
end


disp('################################setup freq')
trialvals = [8 16];
triallabels = {'thr', 'saf'};
lowerfreq = [2, 5, 8, 15, 30];
upperfreq = [4, 7, 12, 29, 59];
tapers = round((upperfreq - lowerfreq)/2);
fbands = {'delta', 'theta', 'alpha', 'beta', 'gamma', 'peak'};
% lowerfreq(6) = peak - 1;
% upperfreq(6) = peak + 1;
% tapers(6) = 2;
% 
% 
lowerfreq(6) = peak - 2;
upperfreq(6) = peak + 2;
tapers(6) = 4;


for j=1:length(fbands)
    
    
    disp('################################do freq analysis with all trials')
    cfg = [];
    cfg.method = 'mtmfft';
    cfg.output = 'powandcsd';
    cfg.channel = 'MEG';
    cfg.keeptrials = 'yes';
    cfg.tapsmofrq = tapers(j);
    cfg.foi = linspace(lowerfreq(j), upperfreq(j), upperfreq(j) - lowerfreq(j) + 1);
    freq = ft_freqanalysis(cfg, data);
    
    disp('################################do source analysis with all trials')
    cfg = [];
    cfg.method = 'dics';
    cfg.grid = leadfield_ctf;
    cfg.headmodel = vol_ctf;
    cfg.grad = grad;
    cfg.channel = 'MEG';
    cfg.dics.lambda = '5%';
    cfg.dics.fixedori = 'yes';
    cfg.dics.keepfilter = 'yes';
    cfg.dics.keeptrials = 'yes';
    source = ft_sourceanalysis(cfg, freq);
    
    commonfilter = source.avg.filter;
    save(strcat(subject, '.', fbands{j}, '.', 'commonfilter.mat'), 'commonfilter');
    
    
    for i=1:length(trialvals)
        
        trialselection = find(data.trialinfo(:,1) == trialvals(i));
        
        disp(strcat('################################do freq analysis', triallabels{i}))
        cfg = [];
        cfg.trials = trialselection;
        cfg.method = 'mtmfft';
        cfg.output = 'powandcsd';
        cfg.channel = 'MEG';
        cfg.keeptrials = 'yes';
        cfg.tapsmofrq = tapers(j);
        cfg.foi = linspace(lowerfreq(j), upperfreq(j), upperfreq(j) - lowerfreq(j) + 1);
        cfg.outputfile = strcat(subject, '.', triallabels{i}, '.clean.pow.', fbands{j}, '.mat');
        trialfreq = ft_freqanalysis(cfg, data);
        
        disp(strcat('################################do source analysis', triallabels{i}))
        cfg = [];
        cfg.method = 'dics';
        cfg.grid = leadfield_ctf;
        cfg.headmodel = vol_ctf;
        cfg.grad = grad;
        cfg.grid.filter = commonfilter;
        cfg.channel = 'MEG';
        cfg.dics.lambda = '5%';
        cfg.dics.fixedori = 'yes';
        cfg.dics.keepfilter = 'yes';
        cfg.dics.keeptrials = 'yes';
        source = ft_sourceanalysis(cfg, trialfreq);
        
        disp('################################write source')
        source.pos = template.sourcemodel.pos;
        source.avg.pow = log(source.avg.pow);
        save(strcat(subject, '.', triallabels{i}, '.clean.dics.', fbands{j}, '.mat'), 'source');
        
        
        disp('################################interpolating sources')
        cfg = [];
        cfg.downsample = 1;
        cfg.parameter = 'pow';
        cfg.interpmethod = 'nearest';
        sourcestat = ft_sourceinterpolate(cfg, source, mri);
        
        disp(strcat('################################writing', ' ', triallabels{i}, ' ', fbands{j}))
        cfg = [];
        cfg.filename = strcat(strcat(subject, '.', triallabels{i}, '.clean.dics.', fbands{j}, '.nii'));
        cfg.filetype = 'nifti';
        cfg.parameter = 'pow';
        cfg.precision = 'double';
        ft_sourcewrite(cfg, sourcestat);
        
    end
    
end
