function reject_components_meg(expdir,subject)

%% runs function to setup the environment for the experiment
if nargin < 2
    subject = [];
end;
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir,subject)
%% 

cd(dspath);

disp('################################load data')
load(strcat(subject, '.alltrials.mat'));

disp('################################load components')
load(strcat(subject, '.components.mat'));

cfg = [];
cfg.component = [1:30];
cfg.layout = 'CTF275.lay';
cfg.marker = 'off';
cfg.comment = 'no';
ft_topoplotIC(cfg, comp);

viewcomp = input('enter the components to reject, separated by spaces:','s');

cfg = [];
cfg.channel = str2num(viewcomp);
cfg.viewmode = 'component';
cfg.layout = 'CTF275.lay';
ft_databrowser(cfg, comp);

yesno = input('enter the components to reject, if unchanged, just hit enter:', 's')

if isempty(yesno)
    rejcomp = viewcomp;
else
    rejcomp = yesno;
end;

cfg = [];
cfg.component = [1:30];
cfg.layout = 'CTF275.lay';
cfg.marker = 'off';
cfg.comment = 'no';
ft_topoplotIC(cfg, comp);
figfname = strcat(subject, '.rejected_components.png')
title(rejcomp);
saveas(gcf, figfname);



disp('################################load components')
cfg = [];
cfg.component = str2num(viewcomp);
cfg.demean = 'yes';
cfg.updatesens = 'yes';
cfg.outputfile = strcat(subject, '.alltrials.clean.mat')
data = ft_rejectcomponent(cfg, comp, data)

reqlicense = license('inuse')
save(strcat(scrdir, '/', 'reject_components_meg.reqlicense.mat'), 'reqlicense');

