function source_statistic_fbands_compile(expdir,stats,fbands,alpha,perms)

%% runs function to setup the environment for the experiment
[ft_home, subdir, mridir, scrdir, logdir, resdir, stmdir, emgdir, matdir, template, dspath, anatpath] = setup_environment(expdir)
%%

disp('################################load template')
mri = ft_read_mri(fullfile(ft_home, '/template/anatomy/single_subj_T1.nii'));

combinedalpha = 0.025;
trialvals = [8 16];
triallabels = {'thr', 'saf'};

cd(resdir)

saflabel = triallabels{2};
thrlabel = triallabels{1};


disp(strcat('################################load ', saflabel));
clear fnames files;
fnames = ls(strcat(subdir, '/*/*/*', saflabel, '.clean.', stats, '.', fbands, '.mat'))
files = strsplit(fnames,'\n');
files(strcmp('',files)) = [];
cfg = [];
cfg.parameter = 'pow';
cfg.keepindividual = 'yes';
cfg.inputfile = files;
saf = ft_sourcegrandaverage(cfg);
saf.dim = template.sourcemodel.dim;

%threat
disp(strcat('################################load ', thrlabel));
clear fnames files;
fnames = ls(strcat(subdir, '/*/*/*', thrlabel, '.clean.', stats, '.', fbands, '.mat'))
files = strsplit(fnames,'\n');
files(strcmp('',files)) = [];
cfg = [];
cfg.parameter = 'pow';
cfg.keepindividual = 'yes';
cfg.inputfile = files;
thr = ft_sourcegrandaverage(cfg);
thr.dim = template.sourcemodel.dim;

disp('################################calculate design matrix')
subj = size(saf.pow,1);
design = zeros(2,2*subj);
for i = 1:subj
    design(1,i) = i;
end
for i = 1:subj
    design(1,subj+i) = i;
end
design(2,1:subj) = 1;
design(2,subj+1:2*subj) = 2;

disp('################################run stats')
cfg = [];
cfg.statistic = 'ft_statfun_depsamplesT';
cfg.parameter = 'pow';
cfg.computeprob = 'yes';
cfg.design = design;
cfg.uvar = 1;
cfg.ivar = 2;
cfg.method = 'montecarlo';
cfg.numrandomization = perms;
cfg.correctm = 'cluster';
cfg.clusterstatistic = 'maxsum';
cfg.clusterthreshold = 'parametric';
cfg.tail = 0;
cfg.clustertail = 0;
cfg.correcttail = 'alpha';
cfg.alpha = combinedalpha;
cfg.clusteralpha = alpha;
cfg.outputfile = strcat(resdir, '/', 'ttest.saf-thr.clean.', stats, '.', fbands, '.mat');
stat = ft_sourcestatistics(cfg, saf, thr);



parameters = {'stat'};
posthresh = [];
negthresh = [];

try
    posclust = squeeze(cell2mat(struct2cell(stat.posclusters)));
    posthresh = max(find(posclust(1,:) < combinedalpha)) + 1
    stat.posclusterslabelmat(find(stat.posclusterslabelmat > posthresh)) = 0;
    parameters = [parameters, 'posclusterslabelmat'];
catch
    disp('################################no pos clusters')
end

try
    negclust = squeeze(cell2mat(struct2cell(stat.negclusters)));
    negthresh = max(find(negclust(1,:) < combinedalpha)) + 1
    stat.negclusterslabelmat(find(stat.negclusterslabelmat > negthresh)) = 0;
    parameters = [parameters, 'negclusterslabelmat'];
catch
    disp('################################no neg clusters')
end

disp('################################interpolating sources')
cfg = [];
cfg.downsample = 1;
cfg.parameter = parameters;
cfg.interpmethod = 'nearest';
sourcestat = ft_sourceinterpolate(cfg, stat, mri);

for l=1:length(parameters)
    
    disp(strcat('################################writing', ' ', parameters{l}))
    cfg = [];
    cfg.filename = strcat(resdir, '/', 'ttest.saf-thr.clean.', stats, '.', fbands, '.', parameters{l}, '.nii');
    cfg.filetype = 'nifti';
    cfg.parameter = parameters{l};
    cfg.precision = 'double';
    ft_sourcewrite(cfg, sourcestat);
    
end
