#!/bin/tcsh
setenv expdir `dirname $PWD`
setenv outfile `basename $0`
setenv subdir ${expdir}/data
setenv mridir ${expdir}/anat
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv resdir ${expdir}/results
setenv stmdir ${expdir}/stimtimes
setenv emgdir ${expdir}/startle
setenv matdir ${expdir}/mfiles
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv mrisubs `ls ${mridir}`
setenv mrisubnum `ls ${mridir} | wc -l`

setenv infile d01.check_motion.csh



foreach subject (${subs})

if (-e ${logdir}/${subject}.${outfile}) then 
	echo "this script has been run for subject $subject"
else

date > ${logdir}/${subject}.${outfile}
more ${scrdir}/${outfile} >> ${logdir}/${subject}.${outfile}


cd ${subdir}/${subject}/*

foreach ds (`ls`)
set dsbasename=`basename $ds .ds`

set lasttrialint=`dshead $ds | grep Trials | cut -d: -f2`

newSingleTrialDs -t 1,$lasttrialint $ds ${dsbasename}-c.ds

end



endif
end




