#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv mridir /raid3/grillon/users/balderstonn/wm_fmri
setenv subdir ${expdir}/data
setenv anadir ${expdir}/anat
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv infile d02.catonate.csh
setenv outfile d03.add_markers.csh
setenv subs `ls ${subdir}`



foreach subject (${subs})

if (-e ${logdir}/${subject}.${infile}) then
if (-e ${logdir}/${subject}.${outfile}) then 
	echo "this script has been run for subject $subject"
else

date > ${logdir}/${subject}.${outfile}
more ${scrdir}/${outfile} >> ${logdir}/${subject}.${outfile}


cd ${subdir}/${subject}/*

foreach ds (`ls -d *-c*`)
set dsbasename=`basename $ds .ds`

addMarker -f -n SAF -q5 1 $ds
addMarker -f -n THR -q4 1 $ds

addMarker -f -n SAF_good -q5 1 -t .2 $ds
addMarker -f -n THR_good -q4 1 -t .2 $ds

end

endif
else
	echo "please run ${infile} for $subject"
endif
end

