#!/bin/tcsh
setenv expdir `dirname $PWD`
setenv outfile `basename $0`
setenv subdir ${expdir}/data
setenv mridir ${expdir}/anat
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv resdir ${expdir}/results
setenv stmdir ${expdir}/stimtimes
setenv emgdir ${expdir}/startle
setenv matdir ${expdir}/mfiles
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv mrisubs `ls ${mridir}`
setenv mrisubnum `ls ${mridir} | wc -l`

setenv swarmmodules afni,python
setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}

setenv MCRROOT /usr/local/matlab-compiler/v85
setenv LD_LIBRARY_PATH .:${MCRROOT}/runtime/glnxa64 ;
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${MCRROOT}/bin/glnxa64 ;
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${MCRROOT}/sys/os/glnxa64;
setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${MCRROOT}/sys/opengl/lib/glnxa64;


foreach fbands (peak delta theta alpha beta gamma)
foreach subject (${subs})


setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${fbands}

if (-e ${logfile}) then 
	echo "this script has been run for subject $subject"
else


#####start of here file
cat > ${logfile} <<End-of-message-fool

${matdir}/process_dics_correlation_compile ${expdir} ${subject} ${fbands}



#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile}" >> ${swarmfile}

endif
end
end

#####run swarm command
cd $scrdir
swarm -t 2 -g 4 --module ${swarmmodules} -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}

