#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`

echo $SUBJECTS_DIR

foreach subject (${subs})

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}
setenv infile ${logdir}/01.Dimon.csh.${subject}.mr_0001

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

cd ${subdir}/${subject}

mkdir clinical
mv *t1.1.76* clinical
mv *t1.8.9* clinical
mv *t1.11* clinical

set t1=`ls *t1*HEAD`

#####start of here file
cat > ${logfile} <<End-of-message-fool
#!/bin/tcsh
setenv SUBJECTS_DIR ${expdir}/anat

cd ${subdir}/${subject}

3dMean -prefix ${subdir}/${subject}/${subject}.anat.nii $t1
recon-all -wsthresh 35 -subjid ${subject} -i ${subdir}/${subject}/${subject}.anat.nii -all

@SUMA_Make_Spec_FS \
-sid ${subject} \
-fspath ${SUBJECTS_DIR}/${subject}

@SUMA_AlignToExperiment \
-exp_anat ${subject}.anat.nii  \
-surf_anat $SUBJECTS_DIR/${subject}/SUMA/${subject}_SurfVol+orig \
-prefix ${subject}_SurfVol_aligned

3dAllineate \
-master ${subject}.anat.nii \
-1Dmatrix_apply ${subject}_SurfVol_aligned.A2E.1D \
-input $SUBJECTS_DIR/${subject}/SUMA/aparc+aseg.nii \
-prefix $SUBJECTS_DIR/${subject}/SUMA/${subject}.fs_aparc+aseg.nii \
-NN \
-final NN

3dAllineate \
-master ${subject}.anat.nii \
-1Dmatrix_apply ${subject}_SurfVol_aligned.A2E.1D \
-input $SUBJECTS_DIR/${subject}/SUMA/aseg.nii \
-prefix $SUBJECTS_DIR/${subject}/SUMA/${subject}.fs_aseg \
-NN \
-final NN

3dAllineate \
-master ${subject}.anat.nii \
-1Dmatrix_apply ${subject}_SurfVol_aligned.A2E.1D \
-input $SUBJECTS_DIR/${subject}/SUMA/brain.nii \
-prefix $SUBJECTS_DIR/${subject}/SUMA/${subject}.anat.fs_ss \
-NN \
-final NN

3dcalc -a $SUBJECTS_DIR/${subject}/SUMA/aseg.nii -expr "amongst(18,a)*a + amongst(54,a)*a" -prefix $SUBJECTS_DIR/${subject}/SUMA/amyg.nii
3dcalc -a $SUBJECTS_DIR/${subject}/SUMA/aseg.nii -expr "amongst(17,a)*a + amongst(53,a)*a" -prefix $SUBJECTS_DIR/${subject}/SUMA/hipp.nii
3dcalc -a $SUBJECTS_DIR/${subject}/SUMA/aseg.nii -expr "amongst(11,a)*a + amongst(50,a)*a" -prefix $SUBJECTS_DIR/${subject}/SUMA/caud.nii

mv $SUBJECTS_DIR/${subject}/SUMA/*fs_* ${subdir}/${subject}

3dcalc \
-a ${subject}.fs_aparc+aseg.nii \
-expr "a - ( \
amongst(2,a)*a + \
amongst(4,a)*a + \
amongst(5,a)*a + \
amongst(7,a)*a + \
amongst(8,a)*a + \
amongst(14,a)*a + \
amongst(15,a)*a + \
amongst(24,a)*a + \
amongst(30,a)*a + \
amongst(31,a)*a + \
amongst(41,a)*a + \
amongst(43,a)*a + \
amongst(44,a)*a + \
amongst(46,a)*a + \
amongst(47,a)*a + \
amongst(62,a)*a + \
amongst(63,a)*a + \
amongst(72,a)*a + \
amongst(77,a)*a + \
amongst(78,a)*a + \
amongst(79,a)*a + \
amongst(80,a)*a + \
amongst(81,a)*a + \
amongst(82,a)*a + \
amongst(85,a)*a + \
amongst(251,a)*a + \
amongst(252,a)*a + \
amongst(253,a)*a + \
amongst(254,a)*a + \
amongst(255,a)*a)" \
-prefix ${subject}.fs_aparc+aseg.mask.nii

3dQwarp -allineate -blur 2 2 \
-base ${resdir}/TT_N27+tlrc \
-source ${subject}.anat.fs_ss+orig \
-prefix ${subject}.anat.fs_ss

3dNwarpApply \
-nwarp "${subject}.anat.fs_ss_WARP+tlrc" \
-ainterp NN \
-dxyz 3 \
-master ${subject}.anat.fs_ss+tlrc \
-source ${subject}.fs_aparc+aseg.mask.nii \
-prefix ${subject}.fs_aparc+aseg.mask.qwarp.nii

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end

#####run swarm command
swarm -R gpfs -t 2 -g 6 -module afni python freesurfer -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}


