#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv outfile `basename $0`
setenv subs `ls ${subdir}`

foreach subject (${subs})
foreach run (run1 run2 run3 run4 forward reversed)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${run}
setenv infile ${logdir}/01.Dimon.csh.${subject}.mr_0001

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

cd ${subdir}/${subject}

set e=""
foreach echotimefname ( `ls ${subject}.${run}.*.echotime` )
set e=($e `more $echotimefname`)
end


#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}

meica.py \
-e ${e[1]},${e[2]},${e[3]} \
-d ${subject}.${run}.${e[1]}+orig,${subject}.${run}.${e[2]}+orig,${subject}.${run}.${e[3]}+orig 

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end

#####run swarm command
swarm -R gpfs -t 2 -g 4 -module afni python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
