#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv outfile `basename $0`
setenv subs `ls ${subdir}`

foreach subject (${subs})
foreach run (run1 run2 run3 run4)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${run}
setenv infile ${logdir}/f01.meica.csh.${subject}.${run}

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

cd ${subdir}/${subject}

set e=""
foreach echotimefname ( `ls ${subject}.${run}.*.echotime` )
set e=($e `more $echotimefname`)
end


#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}

echo "###################################3dmean ${subject}.${run}"
3dTstat -mean \
-prefix ${subject}.${run}.mean \
${subject}.${run}.12_medn.nii.gz

echo "###################################scale ${subject}.${run}"
3dcalc \
-a ${subject}.${run}.12_medn.nii.gz \
-b ${subject}.${run}.mean+orig \
-expr 'min(200, a/b*100)*step(a)*step(b)' \
-prefix ${subject}.${run}.scale

echo "###################################3dallineate ${subject}.${run}"
3dAllineate \
-warp shift_rotate \
-1Dparam_save ${subject}.${run}.1Dparam.1D \
-base ${subject}.run1.mean+orig \
-source ${subject}.${run}.mean+orig \
-prefix ${subject}.${run}.mean_al

echo "###################################3dallineate ${subject}.${run}"
3dAllineate \
-warp shift_rotate \
-master ${subject}.run1.mean+orig \
-1Dparam_apply ${subject}.${run}.1Dparam.1D \
-input ${subject}.${run}.scale+orig \
-prefix ${subject}.${run}.scale_al 

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end

#####run swarm command
swarm -R gpfs -t 2 -g 4 -module afni python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
