#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv outfile `basename $0`
setenv infile f03.align_epi2anat.csh
setenv subs `ls ${subdir}`

foreach subject (${subs})
setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}
setenv infile ${logdir}/f03.align_epi2anat.csh.${subject}.run1

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

#####start of here file
cat > ${logfile} <<End-of-message-fool


cd ${subdir}/${subject}

3dDeconvolve \
-input ${subject}.run?.scale_al+orig.HEAD \
-censor ${stmdir}/${subject}_censor.1D \
-ortvec ${stmdir}/${subject}.motion.1D motion \
-polort A \
-num_stimts 3 \
-stim_file 1 ${stmdir}/${subject}.dial.1D \
-stim_file 2 ${stmdir}/${subject}.transitions.1D \
-stim_file 3 ${stmdir}/${subject}.shock.1D \
-stim_label 1 dial \
-stim_label 2 transitions \
-stim_label 3 shock \
-jobs 16 \
-GOFORIT 8 \
-fout -tout -x1D X.xmat.1D -xjpeg X.jpg \
-x1D_uncensored X.nocensor.xmat.1D \
-fitts ${subject}.fitts \
-errts ${subject}.residuals \
-cbucket ${subject}.all_betas \
-bucket ${subject}.buck

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end

#####run swarm command
swarm -R gpfs -t 16 -g 4 -module afni python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
