#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv outfile `basename $0`
setenv infile 00.Dimon.csh
setenv subs `ls ${subdir}`
setenv shockdur 6
setenv safdur 100
setenv thrdur 100




foreach subject ( $subs )

foreach file ( saf thr )

cd $stmdir

echo "#####1deval $subject $file"
1deval \
-a ${subject}.${file}.1D \
-b ${subject}_censor.1D \
-c censor_last.1D \
-expr "a*b*c" \
> ${subject}.${file}.clean.1D


echo "####1dtool $subject $file"
1d_tool.py \
-infile ${subject}.${file}.clean.1D \
-show_trs_uncensored comma \
> ${subject}.${file}.clean.trs.1D


end
end
