#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`


foreach subject (${subs})
foreach cond (thr saf)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${cond}
setenv infile ${logdir}/f08.3dtcat.csh.${subject}.${cond}

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}

3dNwarpApply \
-nwarp "${subject}.anat.fs_ss_WARP+tlrc" \
-ainterp NN \
-dxyz 3 \
-master ${subject}.anat.fs_ss+tlrc \
-source ${subject}.fs_aparc+aseg.mask.nii \
-prefix ${subject}.fs_aparc+aseg.mask.qwarp.3mm.nii

3dQwarp \
-plusminus \
-base ${subject}.forward.strip_al+orig \
-source ${subject}.reversed.strip_al+orig \
-prefix ${subject}.base

3dAllineate \
-warp shift_rotate \
-1Dmatrix_save ${subject}.base_PLUS_al.1Dmatrix.1D \
-base ${subject}.anat.fs_ss+orig \
-source ${subject}.base_PLUS+orig \
-prefix ${subject}.base_PLUS_al

3dQwarp \
-source ${subject}.anat.fs_ss+orig \
-base ${subject}.base_PLUS_al+orig \
-prefix ${subject}.anat.fs_ss.qepi \
-lpc \
-verb \
-iwarp \
-blur 0 3

3dNwarpApply \
-nwarp "${subject}.anat.fs_ss_WARP+tlrc ${subject}.anat.fs_ss.qepi_WARPINV+orig ${subject}.base_PLUS_al.1Dmatrix.1D ${subject}.base_PLUS_WARP+orig " \
-dxyz 3 \
-master ${subject}.anat.fs_ss+tlrc \
-source $subject.residuals.${cond}.clean+orig \
-prefix $subject.residuals.${cond}.clean.qwarp

3dBlurInMask \
-FWHM 6 \
-mask ${resdir}/group.wm.mask.thresh.nii \
-input $subject.residuals.${cond}.clean.qwarp+tlrc \
-prefix $subject.residuals.${cond}.clean.qwarp.blur.group




#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end

#####run swarm command
#####run swarm command
swarm -t 2 -g 20 -module afni,python,freesurfer --time=48:00:00 -f ${swarmfile}

#####remove swarm file
#rm ${swarmfile}
