#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results 
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`


foreach subject (${subs})
foreach cond (saf thr)
setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${cond}
setenv infile ${logdir}/f09.qwarp.csh.${subject}.${cond}

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else


#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}

mkdir $cond

3dAFNItoANALYZE \
${subject}.${cond} \
${subject}.residuals.${cond}.clean.qwarp.blur.group+tlrc

mv *${cond}*.img $cond
mv *${cond}*.hdr $cond

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end

#####run swarm command
swarm -t 2 -g 20 -module afni,python,freesurfer --time=48:00:00 -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
