#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}
setenv mask ${resdir}/group.wm.mask.thresh.nii

cd ${resdir}/blur_estimate
rm rm.*

foreach blurest (`ls ???.???.qwarp.blur.1D`)
cat ${blurest} | tail -n1 | tee -a rm.errts.blur
end


1dtranspose \
rm.errts.blur \
| tee rm.errts.blur.trans.1D

3dTstat \
-mean \
-prefix - \
rm.errts.blur.trans.1D \
| tee rm.errts.blur.trans.ave

1dtranspose \
rm.errts.blur.trans.ave \
| tee errts.ave

setenv acs `cat errts.ave | tr -s " " | cut -d" " -f2-4`


echo "this is $acs"

rm rm.*


3dClustSim \
-mask ${mask} \
-dxyz 3 3 3 \
-acf $acs \
-MEGA \
-both \
-prefix 3dclustsim

